/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandlingSupport;

@NonNullByDefault
public enum RevisedErrorHandling {
    NONE{

        @Override
        public BGPDocumentedException reportError(BGPError error, @Nullable Exception cause, String format, Object ... args) throws BGPDocumentedException {
            throw new BGPDocumentedException(String.format(format, args), error, cause);
        }
    }
    ,
    INTERNAL,
    EXTERNAL;


    public static RevisedErrorHandling from(@Nullable PeerSpecificParserConstraint constraint) {
        return constraint == null ? NONE : constraint.getPeerConstraint(RevisedErrorHandlingSupport.class).map(support -> support.isExternalPeer() ? EXTERNAL : INTERNAL).orElse(NONE);
    }

    public BGPDocumentedException reportError(BGPError error, @Nullable Exception cause, String format, Object ... args) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        throw new BGPTreatAsWithdrawException(error, cause, format, args);
    }

    public BGPDocumentedException reportError(BGPError error, String format, Object ... args) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        throw this.reportError(error, (Exception)null, format, args);
    }

    public BGPDocumentedException reportError(BGPError error, byte[] data, String format, Object ... args) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        throw new BGPTreatAsWithdrawException(error, data, format, args);
    }
}

