/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;

abstract class AbstractFamilyRegistry<C, N> {
    private final Map<Class<? extends C>, N> classToNumber = new ConcurrentHashMap<Class<? extends C>, N>();
    private final Map<N, Class<? extends C>> numberToClass = new ConcurrentHashMap<N, Class<? extends C>>();

    AbstractFamilyRegistry() {
    }

    protected synchronized Registration registerFamily(final Class<? extends C> clazz, final N number) {
        Objects.requireNonNull(clazz);
        Class<? extends C> c = this.numberToClass.get(number);
        Preconditions.checkState((c == null ? 1 : 0) != 0, (Object)("Number " + number + " already registered to " + c));
        N n = this.classToNumber.get(clazz);
        Preconditions.checkState((n == null ? 1 : 0) != 0, (Object)("Class " + clazz + " already registered to " + n));
        this.numberToClass.put(number, clazz);
        this.classToNumber.put(clazz, number);
        final AbstractFamilyRegistry lock = this;
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                Object object = lock;
                synchronized (object) {
                    AbstractFamilyRegistry.this.classToNumber.remove(clazz);
                    AbstractFamilyRegistry.this.numberToClass.remove(number);
                }
            }
        };
    }

    protected Class<? extends C> classForFamily(N number) {
        return this.numberToClass.get(number);
    }

    protected N numberForClass(Class<? extends C> clazz) {
        return this.classToNumber.get(clazz);
    }
}

