/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.extended.community;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommon;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommonBuilder;

public final class Inet4SpecificExtendedCommunityCommonUtil {
    private Inet4SpecificExtendedCommunityCommonUtil() {
    }

    public static Inet4SpecificExtendedCommunityCommon parseCommon(ByteBuf buffer) {
        return new Inet4SpecificExtendedCommunityCommonBuilder().setGlobalAdministrator(Ipv4Util.addressForByteBuf((ByteBuf)buffer)).setLocalAdministrator(ByteArray.readBytes((ByteBuf)buffer, (int)2)).build();
    }

    public static void serializeCommon(Inet4SpecificExtendedCommunityCommon extComm, ByteBuf byteAggregator) {
        Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)extComm.getGlobalAdministrator(), (ByteBuf)byteAggregator);
        byteAggregator.writeBytes(extComm.getLocalAdministrator());
    }
}

