/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import io.netty.buffer.Unpooled;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.pojo.SimpleAttributeRegistry;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributesKey;

public class UnrecognizedAttributesTest {
    private static final int UNRECOGNIZED_ATTRIBUTE_COUNT = 1;
    private static final int FIRST_ATTRIBUTE = 0;
    private static final short NON_EXISTENT_TYPE = 0;
    private static final int NON_VALUE_BYTES = 3;
    private static final SimpleAttributeRegistry SIMPLE_ATTR_REG = new SimpleAttributeRegistry();

    @Test
    public void testUnrecognizedAttributesWithoutOptionalFlag() throws BGPDocumentedException, BGPParsingException {
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> SIMPLE_ATTR_REG.parseAttributes(Unpooled.wrappedBuffer((byte[])new byte[]{3, 0, 5, 1, 2, 3, 4, 5}), null));
        Assert.assertEquals((Object)"Well known attribute not recognized.", (Object)ex.getMessage());
    }

    @Test
    public void testUnrecognizedAttributes() throws BGPDocumentedException, BGPParsingException {
        byte[] attributeBytes = new byte[]{-32, 0, 5, 1, 2, 3, 4, 5};
        Map unrecogAttribs = SIMPLE_ATTR_REG.parseAttributes(Unpooled.wrappedBuffer((byte[])attributeBytes), null).getAttributes().getUnrecognizedAttributes();
        Assert.assertEquals((long)1L, (long)unrecogAttribs.size());
        UnrecognizedAttributes unrecogAttrib = (UnrecognizedAttributes)unrecogAttribs.values().iterator().next();
        UnrecognizedAttributesKey expectedAttribKey = new UnrecognizedAttributesKey(unrecogAttrib.getType());
        Assert.assertTrue((boolean)unrecogAttrib.isPartial());
        Assert.assertTrue((boolean)unrecogAttrib.isTransitive());
        Assert.assertArrayEquals((byte[])ByteArray.cutBytes((byte[])attributeBytes, (int)3), (byte[])unrecogAttrib.getValue());
        Assert.assertEquals((long)0L, (long)unrecogAttrib.getType().shortValue());
        Assert.assertEquals((Object)expectedAttribKey, (Object)unrecogAttrib.key());
    }
}

