/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractMessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.KeepaliveBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;

public class AbstractMessageRegistryTest {
    public static final byte[] KEEPALIVE_BMSG = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4};
    private final AbstractMessageRegistry registry = new AbstractMessageRegistry(){

        protected void serializeMessageImpl(Notification message, ByteBuf buffer) {
            buffer.writeBytes(KEEPALIVE_BMSG);
        }

        protected Notification parseBody(int type, ByteBuf body, int messageLength, PeerSpecificParserConstraint constraint) throws BGPDocumentedException {
            return new KeepaliveBuilder().build();
        }
    };

    @Test
    public void testRegistry() throws BGPDocumentedException, BGPParsingException {
        Keepalive keepAlive = new KeepaliveBuilder().build();
        ByteBuf buffer = Unpooled.buffer();
        this.registry.serializeMessage((Notification)keepAlive, buffer);
        Assert.assertArrayEquals((byte[])KEEPALIVE_BMSG, (byte[])ByteArray.getAllBytes((ByteBuf)buffer));
        Notification not = this.registry.parseMessage(Unpooled.copiedBuffer((byte[])KEEPALIVE_BMSG), null);
        Assert.assertTrue((boolean)(not instanceof Keepalive));
    }

    @Test
    public void testIncompleteMarker() {
        byte[] testBytes = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4};
        try {
            this.registry.parseMessage(Unpooled.copiedBuffer((byte[])testBytes), null);
            Assert.fail();
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            Assert.assertTrue((boolean)(e instanceof BGPDocumentedException));
            Assert.assertEquals((Object)"Marker not set to ones.", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidLength() {
        byte[] testBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 18, 4};
        try {
            this.registry.parseMessage(Unpooled.copiedBuffer((byte[])testBytes), null);
            Assert.fail();
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            Assert.assertTrue((boolean)(e instanceof BGPDocumentedException));
            Assert.assertEquals((Object)"Message length field not within valid range.", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidSpecifiedSize() {
        byte[] testBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4, 4};
        try {
            this.registry.parseMessage(Unpooled.copiedBuffer((byte[])testBytes), null);
            Assert.fail();
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            Assert.assertTrue((boolean)(e instanceof BGPParsingException));
            Assert.assertTrue((boolean)e.getMessage().startsWith("Size doesn't match size specified in header."));
        }
    }

    @Test
    public void testBGPHeaderParser() throws Exception {
        MessageRegistry msgReg = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getMessageRegistry();
        try {
            msgReg.parseMessage(Unpooled.copiedBuffer((byte[])new byte[]{0, 0}), null);
            Assert.fail((String)"Exception should have occured.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Too few bytes in passed array. Passed: 2. Expected: >= 19.", (Object)e.getMessage());
        }
    }

    @Test
    public void testMessageParser() throws Exception {
        MessageRegistry msgReg = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getMessageRegistry();
        String ex = "";
        try {
            msgReg.serializeMessage(null, Unpooled.EMPTY_BUFFER);
        }
        catch (NullPointerException e) {
            ex = e.getMessage();
        }
        Assert.assertEquals((Object)"BGPMessage is mandatory.", (Object)ex);
    }
}

