/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.spi.PathIdUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeSchemaAwareBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;

public class PathIdUtilTest {
    private ByteBuf buffer;

    @Before
    public void setUp() {
        this.buffer = Unpooled.buffer();
    }

    @Test
    public void testWritePathIdNull() {
        PathIdUtil.writePathId(null, (ByteBuf)this.buffer);
        Assert.assertEquals((long)0L, (long)this.buffer.readableBytes());
    }

    @Test
    public void testWritePathIdZero() {
        PathIdUtil.writePathId((PathId)PathIdUtil.NON_PATH_ID, (ByteBuf)this.buffer);
        Assert.assertEquals((long)0L, (long)this.buffer.readableBytes());
    }

    @Test
    public void testWritePathId() {
        PathIdUtil.writePathId((PathId)new PathId(Uint32.TEN), (ByteBuf)this.buffer);
        Assert.assertEquals((long)4L, (long)this.buffer.readableBytes());
    }

    @Test
    public void testReadPathId() {
        this.buffer.writeInt(10);
        PathId pathId = PathIdUtil.readPathId((ByteBuf)this.buffer);
        Assert.assertEquals((Object)Uint32.TEN, (Object)pathId.getValue());
    }

    @Test
    public void testExtractPathId() {
        YangInstanceIdentifier.NodeIdentifier NII = new YangInstanceIdentifier.NodeIdentifier(QName.create((String)"urn:opendaylight:params:xml:ns:yang:bgp-inet", (String)"2015-03-05", (String)"path-id").intern());
        ContainerNode cont = (ContainerNode)ImmutableContainerNodeSchemaAwareBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NII).addChild((NormalizedNode)((DataContainerChild)new ImmutableLeafNodeBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NII).withValue((Object)Uint32.ZERO).build())).build();
        Assert.assertEquals((long)0L, (long)PathIdUtil.extractPathId((NormalizedNode)cont, (YangInstanceIdentifier.NodeIdentifier)NII).longValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadPathIdBufferNull() {
        PathIdUtil.readPathId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadPathIdBufferEmpty() {
        PathIdUtil.readPathId((ByteBuf)this.buffer);
    }
}

