/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderActivator;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvRegistry;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterRegistry;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityRegistry;
import org.opendaylight.protocol.bgp.parser.spi.pojo.SimpleBGPExtensionProviderContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Singleton
@Component(immediate=true, service={BGPExtensionConsumerContext.class})
public final class DefaultBGPExtensionConsumerContext
implements BGPExtensionConsumerContext {
    private final @NonNull SimpleBGPExtensionProviderContext delegate = new SimpleBGPExtensionProviderContext();

    public DefaultBGPExtensionConsumerContext() {
        this(ServiceLoader.load(BGPExtensionProviderActivator.class));
    }

    @VisibleForTesting
    public DefaultBGPExtensionConsumerContext(BGPExtensionProviderActivator ... extensionActivators) {
        this(Arrays.asList(extensionActivators));
    }

    @Inject
    public DefaultBGPExtensionConsumerContext(Iterable<BGPExtensionProviderActivator> extensionActivators) {
        extensionActivators.forEach(activator -> activator.start(this.delegate));
    }

    @Activate
    public DefaultBGPExtensionConsumerContext(@Reference(policyOption=ReferencePolicyOption.GREEDY) List<BGPExtensionProviderActivator> extensionActivators) {
        extensionActivators.forEach(activator -> activator.start(this.delegate));
    }

    @Override
    public AddressFamilyRegistry getAddressFamilyRegistry() {
        return this.delegate.getAddressFamilyRegistry();
    }

    @Override
    public AttributeRegistry getAttributeRegistry() {
        return this.delegate.getAttributeRegistry();
    }

    @Override
    public CapabilityRegistry getCapabilityRegistry() {
        return this.delegate.getCapabilityRegistry();
    }

    @Override
    public MessageRegistry getMessageRegistry() {
        return this.delegate.getMessageRegistry();
    }

    @Override
    public NlriRegistry getNlriRegistry() {
        return this.delegate.getNlriRegistry();
    }

    @Override
    public ParameterRegistry getParameterRegistry() {
        return this.delegate.getParameterRegistry();
    }

    @Override
    public SubsequentAddressFamilyRegistry getSubsequentAddressFamilyRegistry() {
        return this.delegate.getSubsequentAddressFamilyRegistry();
    }

    @Override
    public ExtendedCommunityRegistry getExtendedCommunityRegistry() {
        return this.delegate.getExtendedCommunityRegistry();
    }

    @Override
    public BgpPrefixSidTlvRegistry getBgpPrefixSidTlvRegistry() {
        return this.delegate.getBgpPrefixSidTlvRegistry();
    }
}

