/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityParser;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityRegistry;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityUtil;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleExtendedCommunityRegistry
implements ExtendedCommunityRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleExtendedCommunityRegistry.class);
    private static final int EXTENDED_COMMUNITY_LENGTH = 6;
    private final HandlerRegistry<DataContainer, ExtendedCommunityParser, ExtendedCommunitySerializer> handlers = new HandlerRegistry();

    SimpleExtendedCommunityRegistry() {
    }

    private static int createKey(int type, int subtype) {
        return type << 8 | subtype;
    }

    @Override
    public ExtendedCommunities parseExtendedCommunity(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        short subtype;
        short type = buffer.readUnsignedByte();
        ExtendedCommunityParser parser = (ExtendedCommunityParser)this.handlers.getParser(SimpleExtendedCommunityRegistry.createKey(type, subtype = buffer.readUnsignedByte()));
        if (parser == null) {
            buffer.skipBytes(6);
            LOG.info("Skipping unknown extended-community type/sub-type {}/{}.", (Object)type, (Object)subtype);
            return null;
        }
        return new ExtendedCommunitiesBuilder().setTransitive(Boolean.valueOf(ExtendedCommunityUtil.isTransitive(type))).setExtendedCommunity(parser.parseExtendedCommunity(buffer)).build();
    }

    @Override
    public void serializeExtendedCommunity(ExtendedCommunities extendedCommunity, ByteBuf byteAggregator) {
        ExtendedCommunitySerializer serializer = (ExtendedCommunitySerializer)this.handlers.getSerializer(extendedCommunity.getExtendedCommunity().implementedInterface());
        if (serializer == null) {
            return;
        }
        byteAggregator.writeByte((int)Shorts.checkedCast((long)serializer.getType(extendedCommunity.getTransitive())));
        byteAggregator.writeByte((int)Shorts.checkedCast((long)serializer.getSubType()));
        serializer.serializeExtendedCommunity(extendedCommunity.getExtendedCommunity(), byteAggregator);
    }

    synchronized Registration registerExtendedCommunitySerializer(Class<? extends ExtendedCommunity> extendedCommunityClass, ExtendedCommunitySerializer serializer) {
        return this.handlers.registerSerializer(extendedCommunityClass, (Object)serializer);
    }

    synchronized Registration registerExtendedCommunityParser(int type, int subtype, ExtendedCommunityParser parser) {
        SimpleExtendedCommunityRegistry.checkTypes(type, subtype);
        return this.handlers.registerParser(SimpleExtendedCommunityRegistry.createKey(type, subtype), (Object)parser);
    }

    private static void checkTypes(int type, int subtype) {
        Preconditions.checkArgument((type >= 0 && type <= 255 ? 1 : 0) != 0, (String)"Illegal extended-community type %s", (int)type);
        Preconditions.checkArgument((subtype >= 0 && subtype <= 255 ? 1 : 0) != 0, (String)"Illegal extended-community sub-type %s", (int)subtype);
    }
}

