/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.ImmutableOffsetMapTemplate;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;

public final class PathIdUtil {
    public static final Uint32 NON_PATH_ID_VALUE = Uint32.ZERO;
    public static final PathId NON_PATH_ID = new PathId(NON_PATH_ID_VALUE);

    private PathIdUtil() {
    }

    public static void writePathId(PathId pathId, ByteBuf buffer) {
        int value;
        if (pathId != null && (value = pathId.getValue().intValue()) != 0) {
            buffer.writeInt(value);
        }
    }

    public static PathId readPathId(ByteBuf buffer) {
        Preconditions.checkArgument((buffer != null && buffer.isReadable(4) ? 1 : 0) != 0);
        return new PathId(ByteBufUtils.readUint32((ByteBuf)buffer));
    }

    public static Uint32 extractPathId(NormalizedNode data, YangInstanceIdentifier.NodeIdentifier pathNii) {
        return NormalizedNodes.findNode((NormalizedNode)data, (YangInstanceIdentifier.PathArgument)pathNii).map(NormalizedNode::body).orElse(null);
    }

    public static PathId buildPathId(DataContainerNode routesCont, YangInstanceIdentifier.NodeIdentifier pathIdNii) {
        Uint32 pathIdVal = PathIdUtil.extractPathId((NormalizedNode)routesCont, pathIdNii);
        return pathIdVal == null ? null : new PathId(pathIdVal);
    }

    public static YangInstanceIdentifier.NodeIdentifierWithPredicates createNidKey(QName routeQName, ImmutableOffsetMapTemplate<QName> routeKeyTemplate, Object routeKeyValue, Optional<DataContainerChild> maybePathIdLeaf) {
        Uint32 pathId = maybePathIdLeaf.isPresent() ? maybePathIdLeaf.get().body() : NON_PATH_ID_VALUE;
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)routeQName, (ImmutableOffsetMap)routeKeyTemplate.instantiateWithValues(new Object[]{pathId, routeKeyValue}));
    }
}

