/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderActivator;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvParser;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvSerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.NextHopParserSerializer;
import org.opendaylight.protocol.bgp.parser.spi.NlriParser;
import org.opendaylight.protocol.bgp.parser.spi.NlriSerializer;
import org.opendaylight.protocol.bgp.parser.spi.ParameterLengthOverflowException;
import org.opendaylight.protocol.bgp.parser.spi.ParameterParser;
import org.opendaylight.protocol.bgp.parser.spi.ParameterSerializer;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityParser;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunitySerializer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.bgp.prefix.sid.bgp.prefix.sid.tlvs.BgpPrefixSidTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteTargetIpv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv6NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;

public class BgpTestActivator
implements BGPExtensionProviderActivator {
    protected static final int TYPE = 0;
    private static final String EMPTY = "";
    @Mock
    protected AttributeSerializer attrSerializer;
    @Mock
    protected AttributeParser attrParser;
    @Mock
    protected ParameterParser paramParser;
    @Mock
    protected ParameterSerializer paramSerializer;
    @Mock
    protected CapabilityParser capaParser;
    @Mock
    protected CapabilitySerializer capaSerializer;
    @Mock
    protected MessageParser msgParser;
    @Mock
    protected MessageSerializer msgSerializer;
    @Mock
    protected NlriParser nlriParser;
    @Mock
    protected NlriSerializer nlriSerializer;
    @Mock
    protected ExtendedCommunityParser exParser;
    @Mock
    protected ExtendedCommunitySerializer exSerializer;
    protected NextHopParserSerializer nextHopParserSerializer;
    @Mock
    protected BgpPrefixSidTlvParser sidTlvParser;
    @Mock
    protected BgpPrefixSidTlvSerializer sidTlvSerializer;

    public List<? extends Registration> start(BGPExtensionProviderContext context) {
        this.initMock();
        ArrayList<Registration> regs = new ArrayList<Registration>();
        regs.add(context.registerAttributeParser(0, this.attrParser));
        regs.add(context.registerAttributeSerializer(DataObject.class, this.attrSerializer));
        regs.add(context.registerParameterParser(0, this.paramParser));
        regs.add(context.registerParameterSerializer(BgpParameters.class, this.paramSerializer));
        regs.add(context.registerCapabilityParser(0, this.capaParser));
        regs.add(context.registerCapabilitySerializer(CParameters.class, this.capaSerializer));
        regs.add(context.registerBgpPrefixSidTlvParser(0, this.sidTlvParser));
        regs.add(context.registerBgpPrefixSidTlvSerializer(BgpPrefixSidTlv.class, this.sidTlvSerializer));
        regs.add(context.registerMessageParser(0, this.msgParser));
        regs.add(context.registerMessageSerializer(MockNotification.class, this.msgSerializer));
        regs.add(context.registerAddressFamily(Ipv4AddressFamily.class, 1));
        regs.add(context.registerAddressFamily(Ipv6AddressFamily.class, 2));
        regs.add(context.registerSubsequentAddressFamily(UnicastSubsequentAddressFamily.class, 1));
        this.nextHopParserSerializer = new NextHopParserSerializer(){

            public CNextHop parseNextHop(ByteBuf buffer) throws BGPParsingException {
                return new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4AddressNoZone("127.0.0.1")).build()).build();
            }

            public void serializeNextHop(CNextHop cnextHop, ByteBuf byteAggregator) {
                byte[] mpReachBytes = new byte[]{127, 0, 0, 1};
                byteAggregator.writeBytes(mpReachBytes);
            }
        };
        regs.add(context.registerNlriParser(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class, this.nlriParser, this.nextHopParserSerializer, Ipv4NextHopCase.class, new Class[0]));
        regs.add(context.registerNlriParser(Ipv6AddressFamily.class, UnicastSubsequentAddressFamily.class, this.nlriParser, this.nextHopParserSerializer, Ipv6NextHopCase.class, new Class[0]));
        regs.add(context.registerNlriSerializer(DataObject.class, this.nlriSerializer));
        regs.add(context.registerExtendedCommunityParser(0, 0, this.exParser));
        regs.add(context.registerExtendedCommunitySerializer(RouteTargetIpv4Case.class, this.exSerializer));
        return regs;
    }

    private void initMock() {
        MockitoAnnotations.initMocks((Object)this);
        try {
            ((AttributeParser)Mockito.doNothing().when((Object)this.attrParser)).parseAttribute((ByteBuf)ArgumentMatchers.any(ByteBuf.class), (AttributesBuilder)ArgumentMatchers.any(AttributesBuilder.class), (RevisedErrorHandling)ArgumentMatchers.any(RevisedErrorHandling.class), (PeerSpecificParserConstraint)ArgumentMatchers.any(PeerSpecificParserConstraint.class));
            ((AttributeParser)Mockito.doReturn((Object)EMPTY).when((Object)this.attrParser)).toString();
            ((AttributeSerializer)Mockito.doNothing().when((Object)this.attrSerializer)).serializeAttribute((Attributes)ArgumentMatchers.any(Attributes.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
            ((AttributeSerializer)Mockito.doReturn((Object)EMPTY).when((Object)this.attrSerializer)).toString();
            ((ParameterParser)Mockito.doReturn(null).when((Object)this.paramParser)).parseParameter((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
            ((ParameterParser)Mockito.doReturn((Object)EMPTY).when((Object)this.paramParser)).toString();
            ((ParameterSerializer)Mockito.doNothing().when((Object)this.paramSerializer)).serializeParameter((BgpParameters)ArgumentMatchers.any(BgpParameters.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
            ((ParameterSerializer)Mockito.doReturn((Object)EMPTY).when((Object)this.paramSerializer)).toString();
            ((CapabilityParser)Mockito.doReturn(null).when((Object)this.capaParser)).parseCapability((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
            ((CapabilityParser)Mockito.doReturn((Object)EMPTY).when((Object)this.capaParser)).toString();
            ((CapabilitySerializer)Mockito.doNothing().when((Object)this.capaSerializer)).serializeCapability((CParameters)ArgumentMatchers.any(CParameters.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
            ((CapabilitySerializer)Mockito.doReturn((Object)EMPTY).when((Object)this.capaSerializer)).toString();
            ((BgpPrefixSidTlvParser)Mockito.doReturn(null).when((Object)this.sidTlvParser)).parseBgpPrefixSidTlv((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
            ((BgpPrefixSidTlvParser)Mockito.doReturn((Object)EMPTY).when((Object)this.sidTlvParser)).toString();
            ((BgpPrefixSidTlvSerializer)Mockito.doNothing().when((Object)this.sidTlvSerializer)).serializeBgpPrefixSidTlv((BgpPrefixSidTlv)ArgumentMatchers.any(BgpPrefixSidTlv.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
            ((BgpPrefixSidTlvSerializer)Mockito.doReturn((Object)EMPTY).when((Object)this.sidTlvSerializer)).toString();
            ((BgpPrefixSidTlvSerializer)Mockito.doReturn((Object)0).when((Object)this.sidTlvSerializer)).getType();
            ((MessageParser)Mockito.doReturn((Object)Mockito.mock(Notification.class)).when((Object)this.msgParser)).parseMessageBody((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.anyInt(), (PeerSpecificParserConstraint)ArgumentMatchers.any(PeerSpecificParserConstraint.class));
            ((MessageParser)Mockito.doReturn((Object)EMPTY).when((Object)this.msgParser)).toString();
            ((MessageSerializer)Mockito.doNothing().when((Object)this.msgSerializer)).serializeMessage((Notification)ArgumentMatchers.any(Notification.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
            ((MessageSerializer)Mockito.doReturn((Object)EMPTY).when((Object)this.msgSerializer)).toString();
            ((NlriParser)Mockito.doNothing().when((Object)this.nlriParser)).parseNlri((ByteBuf)ArgumentMatchers.any(ByteBuf.class), (MpUnreachNlriBuilder)ArgumentMatchers.any(MpUnreachNlriBuilder.class), (PeerSpecificParserConstraint)ArgumentMatchers.any());
            ((NlriParser)Mockito.doNothing().when((Object)this.nlriParser)).parseNlri((ByteBuf)ArgumentMatchers.any(ByteBuf.class), (MpReachNlriBuilder)ArgumentMatchers.any(MpReachNlriBuilder.class), (PeerSpecificParserConstraint)ArgumentMatchers.any());
            ((NlriParser)Mockito.doReturn((Object)EMPTY).when((Object)this.nlriParser)).toString();
        }
        catch (BGPDocumentedException | BGPParsingException | BGPTreatAsWithdrawException | ParameterLengthOverflowException e) {
            throw new IllegalStateException("Mock setup failed", e);
        }
    }

    static interface MockNotification
    extends DataObject,
    Notification<MockNotification> {
        default public Class<MockNotification> implementedInterface() {
            return MockNotification.class;
        }
    }
}

