/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.spi.ParameterLengthOverflowException;

public final class ParameterUtil {
    private ParameterUtil() {
    }

    public static void formatParameter(int type, ByteBuf value, ByteBuf buffer) throws ParameterLengthOverflowException {
        int valueLength = value.writerIndex();
        ParameterLengthOverflowException.throwIf(valueLength > 255, "Cannot encode %s-byte value", valueLength);
        buffer.writeByte(type);
        buffer.writeByte(valueLength);
        buffer.writeBytes(value);
    }

    public static void formatExtendedParameter(int type, ByteBuf value, ByteBuf buffer) {
        int valueLength = value.writerIndex();
        Preconditions.checkArgument((valueLength < 65535 ? 1 : 0) != 0, (String)"Cannot encode %s-byte value", (int)valueLength);
        buffer.writeByte(type);
        buffer.writeShort(valueLength);
        buffer.writeBytes(value);
    }
}

