/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityUtil;
import org.opendaylight.protocol.bgp.parser.spi.MessageUtil;
import org.opendaylight.protocol.bgp.parser.spi.MultiprotocolCapabilitiesUtil;
import org.opendaylight.protocol.bgp.parser.spi.ParameterLengthOverflowException;
import org.opendaylight.protocol.bgp.parser.spi.ParameterUtil;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class UtilsTest {
    @Mock
    private AddressFamilyRegistry afiReg;
    @Mock
    private SubsequentAddressFamilyRegistry safiReg;

    @Before
    public void setUp() {
        ((AddressFamilyRegistry)Mockito.doReturn((Object)1).when((Object)this.afiReg)).numberForClass((AddressFamily)Ipv4AddressFamily.VALUE);
        ((AddressFamilyRegistry)Mockito.doReturn((Object)Ipv4AddressFamily.VALUE).when((Object)this.afiReg)).classForFamily(1);
        ((AddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.afiReg)).classForFamily(2);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn((Object)1).when((Object)this.safiReg)).numberForClass((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn((Object)UnicastSubsequentAddressFamily.VALUE).when((Object)this.safiReg)).classForFamily(1);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.safiReg)).classForFamily(3);
    }

    @Test
    public void testCapabilityUtil() {
        byte[] result = new byte[]{1, 2, 4, 8};
        ByteBuf aggregator = Unpooled.buffer();
        CapabilityUtil.formatCapability((int)1, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{4, 8}), (ByteBuf)aggregator);
        Assert.assertArrayEquals((byte[])result, (byte[])ByteArray.getAllBytes((ByteBuf)aggregator));
    }

    @Test
    public void testMessageUtil() {
        byte[] result = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 23, 3, 32, 5, 14, 21};
        ByteBuf formattedMessage = Unpooled.buffer();
        MessageUtil.formatMessage((int)3, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{32, 5, 14, 21}), (ByteBuf)formattedMessage);
        Assert.assertArrayEquals((byte[])result, (byte[])ByteArray.getAllBytes((ByteBuf)formattedMessage));
    }

    @Test
    public void testParameterUtil() throws ParameterLengthOverflowException {
        byte[] result = new byte[]{1, 2, 4, 8};
        ByteBuf aggregator = Unpooled.buffer();
        ParameterUtil.formatParameter((int)1, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{4, 8}), (ByteBuf)aggregator);
        Assert.assertArrayEquals((byte[])result, (byte[])ByteArray.getAllBytes((ByteBuf)aggregator));
    }

    @Test
    public void testAttributeUtil() {
        byte[] result = new byte[]{64, 3, 4, 10, 0, 0, 2};
        ByteBuf aggregator = Unpooled.buffer();
        AttributeUtil.formatAttribute((int)64, (int)3, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{10, 0, 0, 2}), (ByteBuf)aggregator);
        Assert.assertArrayEquals((byte[])result, (byte[])ByteArray.getAllBytes((ByteBuf)aggregator));
    }

    @Test
    public void testAttributeUtilExtended() {
        byte[] value = new byte[258];
        Arrays.fill(value, 0, 258, (byte)-1);
        byte[] header = new byte[]{80, 3, 1, 2};
        byte[] result = new byte[262];
        System.arraycopy(header, 0, result, 0, header.length);
        System.arraycopy(value, 0, result, 4, value.length);
        ByteBuf aggregator = Unpooled.buffer();
        AttributeUtil.formatAttribute((int)64, (int)3, (ByteBuf)Unpooled.wrappedBuffer((byte[])value), (ByteBuf)aggregator);
        Assert.assertArrayEquals((byte[])result, (byte[])ByteArray.getAllBytes((ByteBuf)aggregator));
    }

    @Test
    public void testMultiprotocolCapabilitiesUtil() throws BGPParsingException {
        byte[] bytes = new byte[]{0, 1, 0, 1};
        ByteBuf bytesBuf = Unpooled.copiedBuffer((byte[])bytes);
        BgpTableType parsedAfiSafi = (BgpTableType)MultiprotocolCapabilitiesUtil.parseMPAfiSafi((ByteBuf)bytesBuf, (AddressFamilyRegistry)this.afiReg, (SubsequentAddressFamilyRegistry)this.safiReg).get();
        Assert.assertEquals((Object)Ipv4AddressFamily.VALUE, (Object)parsedAfiSafi.getAfi());
        Assert.assertEquals((Object)UnicastSubsequentAddressFamily.VALUE, (Object)parsedAfiSafi.getSafi());
        ByteBuf serializedAfiSafi = Unpooled.buffer((int)4);
        MultiprotocolCapabilitiesUtil.serializeMPAfiSafi((AddressFamilyRegistry)this.afiReg, (SubsequentAddressFamilyRegistry)this.safiReg, (AddressFamily)Ipv4AddressFamily.VALUE, (SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE, (ByteBuf)serializedAfiSafi);
        Assert.assertArrayEquals((byte[])bytes, (byte[])serializedAfiSafi.array());
    }

    @Test
    public void testUnsupportedAfi() {
        byte[] bytes = new byte[]{0, 2, 0, 1};
        ByteBuf bytesBuf = Unpooled.copiedBuffer((byte[])bytes);
        Optional parsedAfiSafi = MultiprotocolCapabilitiesUtil.parseMPAfiSafi((ByteBuf)bytesBuf, (AddressFamilyRegistry)this.afiReg, (SubsequentAddressFamilyRegistry)this.safiReg);
        Assert.assertFalse((boolean)parsedAfiSafi.isPresent());
    }

    @Test
    public void testUnsupportedSafi() {
        byte[] bytes = new byte[]{0, 1, 0, 3};
        ByteBuf bytesBuf = Unpooled.copiedBuffer((byte[])bytes);
        Optional parsedAfiSafi = MultiprotocolCapabilitiesUtil.parseMPAfiSafi((ByteBuf)bytesBuf, (AddressFamilyRegistry)this.afiReg, (SubsequentAddressFamilyRegistry)this.safiReg);
        Assert.assertFalse((boolean)parsedAfiSafi.isPresent());
    }

    @Test(expected=ParameterLengthOverflowException.class)
    public void testFormatParameterOverflow() throws ParameterLengthOverflowException {
        ParameterUtil.formatParameter((int)2, (ByteBuf)Unpooled.buffer().writeZero(256), (ByteBuf)Unpooled.buffer());
    }

    @Test
    public void testFormatParameter() throws ParameterLengthOverflowException {
        ByteBuf output = Unpooled.buffer();
        ParameterUtil.formatParameter((int)2, (ByteBuf)Unpooled.buffer().writeZero(255), (ByteBuf)output);
        Assert.assertEquals((long)257L, (long)output.readableBytes());
        Assert.assertEquals((long)2L, (long)output.readUnsignedByte());
        Assert.assertEquals((long)255L, (long)output.readUnsignedByte());
    }

    @Test
    public void testFormatExtendedParameter() {
        ByteBuf output = Unpooled.buffer();
        ParameterUtil.formatExtendedParameter((int)2, (ByteBuf)Unpooled.buffer().writeZero(256), (ByteBuf)output);
        Assert.assertEquals((long)259L, (long)output.readableBytes());
        Assert.assertEquals((long)2L, (long)output.readUnsignedByte());
        Assert.assertEquals((long)256L, (long)output.readUnsignedShort());
    }
}

