/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupport;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;

public final class MultiPathSupportUtil {
    private MultiPathSupportUtil() {
    }

    public static boolean isTableTypeSupported(@Nullable PeerSpecificParserConstraint constraints, @NonNull BgpTableType afiSafi) {
        Objects.requireNonNull(afiSafi);
        if (constraints != null) {
            Optional<MultiPathSupport> peerConstraint = constraints.getPeerConstraint(MultiPathSupport.class);
            return peerConstraint.isPresent() && peerConstraint.orElseThrow().isTableTypeSupported(afiSafi);
        }
        return false;
    }
}

