/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvParser;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvSerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupport;
import org.opendaylight.protocol.bgp.parser.spi.NlriParser;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterRegistry;
import org.opendaylight.protocol.bgp.parser.spi.PeerConstraint;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.pojo.BgpTestActivator;
import org.opendaylight.protocol.bgp.parser.spi.pojo.PeerSpecificParserConstraintImpl;
import org.opendaylight.protocol.bgp.parser.spi.pojo.SimpleBGPExtensionProviderContext;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.bgp.prefix.sid.bgp.prefix.sid.tlvs.BgpPrefixSidTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.Notification;

public class SimpleRegistryTest {
    private static final MultiPathSupport ADD_PATH_SUPPORT = tableType -> true;
    private static final PeerSpecificParserConstraint CONSTRAINT;
    protected BGPExtensionConsumerContext ctx;
    private final BgpTestActivator activator = new BgpTestActivator();
    private List<? extends Registration> regs;

    @Before
    public void setUp() {
        SimpleBGPExtensionProviderContext provider = new SimpleBGPExtensionProviderContext();
        this.ctx = provider;
        this.regs = this.activator.start((BGPExtensionProviderContext)provider);
    }

    @After
    public void tearDown() {
        this.regs.forEach(Registration::close);
    }

    @Test
    public void testSimpleAttribute() throws BGPDocumentedException, BGPParsingException, BGPTreatAsWithdrawException {
        AttributeRegistry attrReg = this.ctx.getAttributeRegistry();
        byte[] attributeBytes = new byte[]{0, 0, 0};
        ByteBuf byteAggregator = Unpooled.buffer((int)attributeBytes.length);
        attrReg.serializeAttribute((Attributes)Mockito.mock(Attributes.class), byteAggregator);
        attrReg.parseAttributes(Unpooled.wrappedBuffer((byte[])attributeBytes), CONSTRAINT);
        ((AttributeParser)Mockito.verify((Object)this.activator.attrParser, (VerificationMode)Mockito.times((int)1))).parseAttribute((ByteBuf)ArgumentMatchers.any(ByteBuf.class), (AttributesBuilder)ArgumentMatchers.any(AttributesBuilder.class), (RevisedErrorHandling)ArgumentMatchers.any(RevisedErrorHandling.class), (PeerSpecificParserConstraint)ArgumentMatchers.any(PeerSpecificParserConstraint.class));
        ((AttributeSerializer)Mockito.verify((Object)this.activator.attrSerializer, (VerificationMode)Mockito.times((int)1))).serializeAttribute((Attributes)ArgumentMatchers.any(Attributes.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test
    public void testSimpleParameter() throws Exception {
        ParameterRegistry paramReg = this.ctx.getParameterRegistry();
        BgpParameters param = (BgpParameters)Mockito.mock(BgpParameters.class);
        ((BgpParameters)Mockito.doReturn(BgpParameters.class).when((Object)param)).implementedInterface();
        Assert.assertEquals(Optional.of(this.activator.paramParser), (Object)paramReg.findParser(0));
        Assert.assertEquals(Optional.of(this.activator.paramSerializer), (Object)paramReg.findSerializer(param));
    }

    @Test
    public void testSimpleCapability() throws Exception {
        CapabilityRegistry capaRegistry = this.ctx.getCapabilityRegistry();
        byte[] capabilityBytes = new byte[]{0, 0};
        capaRegistry.parseCapability(0, Unpooled.wrappedBuffer((byte[])capabilityBytes));
        ((CapabilityParser)Mockito.verify((Object)this.activator.capaParser, (VerificationMode)Mockito.times((int)1))).parseCapability((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test
    public void testSimpleBgpPrefixSidTlvRegistry() {
        BgpPrefixSidTlvRegistry sidTlvReg = this.ctx.getBgpPrefixSidTlvRegistry();
        byte[] tlvBytes = new byte[]{0, 3, 0, 0, 0};
        BgpPrefixSidTlv tlv = (BgpPrefixSidTlv)Mockito.mock(BgpPrefixSidTlv.class);
        ((BgpPrefixSidTlv)Mockito.doReturn(BgpPrefixSidTlv.class).when((Object)tlv)).implementedInterface();
        ByteBuf buffer = Unpooled.buffer((int)tlvBytes.length);
        sidTlvReg.serializeBgpPrefixSidTlv(tlv, buffer);
        ((BgpPrefixSidTlvSerializer)Mockito.verify((Object)this.activator.sidTlvSerializer, (VerificationMode)Mockito.times((int)1))).serializeBgpPrefixSidTlv((BgpPrefixSidTlv)ArgumentMatchers.any(BgpPrefixSidTlv.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
        sidTlvReg.parseBgpPrefixSidTlv(0, Unpooled.wrappedBuffer((byte[])tlvBytes));
        ((BgpPrefixSidTlvParser)Mockito.verify((Object)this.activator.sidTlvParser, (VerificationMode)Mockito.times((int)1))).parseBgpPrefixSidTlv((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test
    public void testSimpleMessageRegistry() throws Exception {
        MessageRegistry msgRegistry = this.ctx.getMessageRegistry();
        byte[] msgBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 0};
        BgpTestActivator.MockNotification msg = (BgpTestActivator.MockNotification)Mockito.mock(BgpTestActivator.MockNotification.class);
        ((BgpTestActivator.MockNotification)Mockito.doReturn(BgpTestActivator.MockNotification.class).when((Object)msg)).implementedInterface();
        ByteBuf buffer = Unpooled.buffer((int)msgBytes.length);
        msgRegistry.serializeMessage((Notification)msg, buffer);
        msgRegistry.parseMessage(Unpooled.wrappedBuffer((byte[])msgBytes), CONSTRAINT);
        ((MessageParser)Mockito.verify((Object)this.activator.msgParser, (VerificationMode)Mockito.times((int)1))).parseMessageBody((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.anyInt(), (PeerSpecificParserConstraint)ArgumentMatchers.any(PeerSpecificParserConstraint.class));
        ((MessageSerializer)Mockito.verify((Object)this.activator.msgSerializer, (VerificationMode)Mockito.times((int)1))).serializeMessage((Notification)ArgumentMatchers.any(Notification.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test
    public void testAfiRegistry() throws Exception {
        AddressFamilyRegistry afiRegistry = this.ctx.getAddressFamilyRegistry();
        Assert.assertEquals((Object)Ipv4AddressFamily.VALUE, (Object)afiRegistry.classForFamily(1));
        Assert.assertEquals((long)1L, (long)afiRegistry.numberForClass((AddressFamily)Ipv4AddressFamily.VALUE).intValue());
    }

    @Test
    public void testSafiRegistry() throws Exception {
        SubsequentAddressFamilyRegistry safiRegistry = this.ctx.getSubsequentAddressFamilyRegistry();
        Assert.assertEquals((Object)UnicastSubsequentAddressFamily.VALUE, (Object)safiRegistry.classForFamily(1));
        Assert.assertEquals((long)1L, (long)safiRegistry.numberForClass((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).intValue());
    }

    @Test
    public void testMpReachParser() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpReachBytes = new byte[]{0, 1, 1, 4, 127, 0, 0, 1, 0};
        MpReachNlri mpReach = new MpReachNlriBuilder().setAfi((AddressFamily)Ipv4AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).setCNextHop((CNextHop)new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4AddressNoZone("127.0.0.1")).build()).build()).build();
        ByteBuf buffer = Unpooled.buffer((int)mpReachBytes.length);
        nlriReg.serializeMpReach(mpReach, buffer);
        Assert.assertArrayEquals((byte[])mpReachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpReach, (Object)nlriReg.parseMpReach(Unpooled.wrappedBuffer((byte[])mpReachBytes), CONSTRAINT));
        ((NlriParser)Mockito.verify((Object)this.activator.nlriParser, (VerificationMode)Mockito.times((int)1))).parseNlri((ByteBuf)ArgumentMatchers.any(ByteBuf.class), (MpReachNlriBuilder)ArgumentMatchers.any(MpReachNlriBuilder.class), (PeerSpecificParserConstraint)ArgumentMatchers.any());
    }

    @Test
    public void testMpReachWithZeroNextHop() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpReachBytes = new byte[]{0, 1, 1, 0, 0};
        MpReachNlri mpReach = new MpReachNlriBuilder().setAfi((AddressFamily)Ipv4AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build();
        ByteBuf buffer = Unpooled.buffer((int)mpReachBytes.length);
        nlriReg.serializeMpReach(mpReach, buffer);
        Assert.assertArrayEquals((byte[])mpReachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpReach, (Object)nlriReg.parseMpReach(Unpooled.wrappedBuffer((byte[])mpReachBytes), CONSTRAINT));
    }

    @Test
    public void testMpReachIpv6() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpReachBytes = new byte[]{0, 2, 1, 0, 0};
        MpReachNlri mpReach = new MpReachNlriBuilder().setAfi((AddressFamily)Ipv6AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build();
        ByteBuf buffer = Unpooled.buffer((int)mpReachBytes.length);
        nlriReg.serializeMpReach(mpReach, buffer);
        Assert.assertArrayEquals((byte[])mpReachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpReach, (Object)nlriReg.parseMpReach(Unpooled.wrappedBuffer((byte[])mpReachBytes), CONSTRAINT));
    }

    @Test
    public void testEOTMpUnReachParser() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpUnreachBytes = new byte[]{0, 1, 1};
        MpUnreachNlri mpUnreach = new MpUnreachNlriBuilder().setAfi((AddressFamily)Ipv4AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build();
        ByteBuf buffer = Unpooled.buffer((int)mpUnreachBytes.length);
        nlriReg.serializeMpUnReach(mpUnreach, buffer);
        Assert.assertArrayEquals((byte[])mpUnreachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpUnreach, (Object)nlriReg.parseMpUnreach(Unpooled.wrappedBuffer((byte[])mpUnreachBytes), CONSTRAINT));
        ((NlriParser)Mockito.verify((Object)this.activator.nlriParser, (VerificationMode)Mockito.never())).parseNlri((ByteBuf)ArgumentMatchers.any(ByteBuf.class), (MpUnreachNlriBuilder)ArgumentMatchers.any(MpUnreachNlriBuilder.class), (PeerSpecificParserConstraint)ArgumentMatchers.any());
    }

    static {
        PeerSpecificParserConstraintImpl peerConstraint = new PeerSpecificParserConstraintImpl();
        peerConstraint.addPeerConstraint(MultiPathSupport.class, (PeerConstraint)ADD_PATH_SUPPORT);
        CONSTRAINT = peerConstraint;
    }
}

