/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractMessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.pojo.DefaultBGPExtensionConsumerContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.KeepaliveBuilder;
import org.opendaylight.yangtools.binding.Notification;

public class AbstractMessageRegistryTest {
    public static final byte[] KEEPALIVE_BMSG = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4};
    private final AbstractMessageRegistry registry = new AbstractMessageRegistry(this){

        protected void serializeMessageImpl(Notification<?> message, ByteBuf buffer) {
            buffer.writeBytes(KEEPALIVE_BMSG);
        }

        protected Notification<?> parseBody(int type, ByteBuf body, int messageLength, PeerSpecificParserConstraint constraint) throws BGPDocumentedException {
            return new KeepaliveBuilder().build();
        }
    };

    @Test
    public void testRegistry() throws BGPDocumentedException, BGPParsingException {
        Keepalive keepAlive = new KeepaliveBuilder().build();
        ByteBuf buffer = Unpooled.buffer();
        this.registry.serializeMessage((Notification)keepAlive, buffer);
        Assert.assertArrayEquals((byte[])KEEPALIVE_BMSG, (byte[])ByteArray.getAllBytes((ByteBuf)buffer));
        Notification not = this.registry.parseMessage(Unpooled.copiedBuffer((byte[])KEEPALIVE_BMSG), null);
        MatcherAssert.assertThat((Object)not, (Matcher)CoreMatchers.instanceOf(Keepalive.class));
    }

    @Test
    public void testIncompleteMarker() {
        byte[] testBytes = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4};
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> this.registry.parseMessage(Unpooled.copiedBuffer((byte[])testBytes), null));
        Assert.assertEquals((Object)"Marker not set to ones.", (Object)ex.getMessage());
    }

    @Test
    public void testInvalidLength() {
        byte[] testBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 18, 4};
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> this.registry.parseMessage(Unpooled.copiedBuffer((byte[])testBytes), null));
        Assert.assertEquals((Object)"Message length field not within valid range.", (Object)ex.getMessage());
    }

    @Test
    public void testInvalidSpecifiedSize() {
        byte[] testBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4, 4};
        BGPParsingException ex = (BGPParsingException)Assert.assertThrows(BGPParsingException.class, () -> this.registry.parseMessage(Unpooled.copiedBuffer((byte[])testBytes), null));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Size doesn't match size specified in header."));
    }

    @Test
    public void testBGPHeaderParser() {
        MessageRegistry msgReg = new DefaultBGPExtensionConsumerContext().getMessageRegistry();
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> msgReg.parseMessage(Unpooled.copiedBuffer((byte[])new byte[]{0, 0}), null));
        Assert.assertEquals((Object)"Too few bytes in passed array. Passed: 2. Expected: >= 19.", (Object)ex.getMessage());
    }

    @Test
    public void testMessageParser() {
        MessageRegistry msgReg = new DefaultBGPExtensionConsumerContext().getMessageRegistry();
        NullPointerException ex = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> msgReg.serializeMessage(null, Unpooled.EMPTY_BUFFER));
        Assert.assertEquals((Object)"BGPMessage is mandatory.", (Object)ex.getMessage());
    }
}

