/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opendaylight.protocol.bgp.parser.spi.PathIdUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;

class PathIdUtilTest {
    private final ByteBuf buffer = Unpooled.buffer();

    PathIdUtilTest() {
    }

    @Test
    void testWritePathIdNull() {
        PathIdUtil.writePathId(null, (ByteBuf)this.buffer);
        Assertions.assertEquals((int)0, (int)this.buffer.readableBytes());
    }

    @Test
    void testWritePathIdZero() {
        PathIdUtil.writePathId((PathId)PathIdUtil.NON_PATH_ID, (ByteBuf)this.buffer);
        Assertions.assertEquals((int)0, (int)this.buffer.readableBytes());
    }

    @Test
    void testWritePathId() {
        PathIdUtil.writePathId((PathId)new PathId(Uint32.TEN), (ByteBuf)this.buffer);
        Assertions.assertEquals((int)4, (int)this.buffer.readableBytes());
    }

    @Test
    void testReadPathId() {
        this.buffer.writeInt(10);
        PathId pathId = PathIdUtil.readPathId((ByteBuf)this.buffer);
        Assertions.assertEquals((Object)Uint32.TEN, (Object)pathId.getValue());
    }

    @Test
    void testExtractPathId() {
        YangInstanceIdentifier.NodeIdentifier NII = new YangInstanceIdentifier.NodeIdentifier(QName.create((String)"urn:opendaylight:params:xml:ns:yang:bgp-inet", (String)"2015-03-05", (String)"path-id").intern());
        ContainerNode cont = (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NII).addChild((NormalizedNode)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)NII, (Object)Uint32.ZERO)).build();
        Assertions.assertEquals((long)0L, (long)PathIdUtil.extractPathId((NormalizedNode)cont, (YangInstanceIdentifier.NodeIdentifier)NII).longValue());
    }

    @Test
    void testReadPathIdBufferNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathIdUtil.readPathId(null));
    }

    @Test
    void testReadPathIdBufferEmpty() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathIdUtil.readPathId((ByteBuf)this.buffer));
    }
}

