/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupport;
import org.opendaylight.protocol.bgp.parser.spi.pojo.MultiPathSupportImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.SendReceive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamilies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamiliesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.MplsLabeledVpnSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;

public class MultiPathSupportImplTest {
    @Test(expected=NullPointerException.class)
    public void testcreateParserMultiPathSupportNull() {
        MultiPathSupportImpl.createParserMultiPathSupport(null);
    }

    @Test
    public void testIsTableTypeSupported() {
        ArrayList<AddressFamilies> supportedTables = new ArrayList<AddressFamilies>();
        BgpTableTypeImpl ipv4Unicast = new BgpTableTypeImpl((AddressFamily)Ipv4AddressFamily.VALUE, (SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE);
        BgpTableTypeImpl ipv4L3vpn = new BgpTableTypeImpl((AddressFamily)Ipv4AddressFamily.VALUE, (SubsequentAddressFamily)MplsLabeledVpnSubsequentAddressFamily.VALUE);
        BgpTableTypeImpl ipv6Unicast = new BgpTableTypeImpl((AddressFamily)Ipv6AddressFamily.VALUE, (SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE);
        BgpTableTypeImpl ipv6L3vpn = new BgpTableTypeImpl((AddressFamily)Ipv6AddressFamily.VALUE, (SubsequentAddressFamily)MplsLabeledVpnSubsequentAddressFamily.VALUE);
        supportedTables.add(MultiPathSupportImplTest.createAddPathCapability((BgpTableType)ipv4Unicast, SendReceive.Send));
        supportedTables.add(MultiPathSupportImplTest.createAddPathCapability((BgpTableType)ipv4L3vpn, SendReceive.Receive));
        supportedTables.add(MultiPathSupportImplTest.createAddPathCapability((BgpTableType)ipv6Unicast, SendReceive.Both));
        MultiPathSupport multiPathSupport = MultiPathSupportImpl.createParserMultiPathSupport(supportedTables);
        Assert.assertTrue((boolean)multiPathSupport.isTableTypeSupported((BgpTableType)ipv4Unicast));
        Assert.assertTrue((boolean)multiPathSupport.isTableTypeSupported((BgpTableType)ipv6Unicast));
        Assert.assertFalse((boolean)multiPathSupport.isTableTypeSupported((BgpTableType)ipv4L3vpn));
        Assert.assertFalse((boolean)multiPathSupport.isTableTypeSupported((BgpTableType)ipv6L3vpn));
    }

    private static AddressFamilies createAddPathCapability(BgpTableType afisafi, SendReceive mode) {
        return new AddressFamiliesBuilder().setAfi(afisafi.getAfi()).setSafi(afisafi.getSafi()).setSendReceive(mode).build();
    }
}

