/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import java.util.Collections;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupport;
import org.opendaylight.protocol.bgp.parser.spi.PeerConstraint;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraintProvider;
import org.opendaylight.protocol.bgp.parser.spi.pojo.MultiPathSupportImpl;
import org.opendaylight.protocol.bgp.parser.spi.pojo.PeerSpecificParserConstraintImpl;

public class PeerSpecificParserConstraintImplTest {
    private static final MultiPathSupport ADD_PATH_CONSTRAINT = MultiPathSupportImpl.createParserMultiPathSupport(Collections.emptyList());
    private PeerSpecificParserConstraintProvider constraints;

    @Before
    public void setUp() {
        this.constraints = new PeerSpecificParserConstraintImpl();
    }

    @Test
    public void testProviderSucess() {
        Assert.assertTrue((boolean)this.constraints.addPeerConstraint(MultiPathSupport.class, (PeerConstraint)ADD_PATH_CONSTRAINT));
    }

    @Test
    public void testProviderAlreadyPresent() {
        this.constraints.addPeerConstraint(MultiPathSupport.class, (PeerConstraint)ADD_PATH_CONSTRAINT);
        Assert.assertFalse((boolean)this.constraints.addPeerConstraint(MultiPathSupport.class, (PeerConstraint)ADD_PATH_CONSTRAINT));
    }

    @Test(expected=NullPointerException.class)
    public void testProviderNullInput() {
        this.constraints.addPeerConstraint(MultiPathSupport.class, null);
    }

    @Test
    public void testGetPeerConstraintSuccess() {
        this.constraints.addPeerConstraint(MultiPathSupport.class, (PeerConstraint)ADD_PATH_CONSTRAINT);
        Optional peerConstraint = this.constraints.getPeerConstraint(MultiPathSupport.class);
        Assert.assertTrue((boolean)peerConstraint.isPresent());
    }

    @Test
    public void testGetPeerConstraintNonExisting() {
        Optional peerConstraint = this.constraints.getPeerConstraint(MultiPathSupport.class);
        Assert.assertFalse((boolean)peerConstraint.isPresent());
    }
}

