/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityParser;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.pojo.SimpleExtendedCommunityRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteOriginIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteTargetIpv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteTargetIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.route.target.ipv4.grouping.RouteTargetIpv4Builder;

public class SimpleExtendedCommunityRegistryTest {
    private SimpleExtendedCommunityRegistry register;
    private final ExtendedCommunityParser parser = (ExtendedCommunityParser)Mockito.mock(ExtendedCommunityParser.class);
    private final ExtendedCommunitySerializer serializer = (ExtendedCommunitySerializer)Mockito.mock(ExtendedCommunitySerializer.class);

    @Before
    public void setup() throws BGPDocumentedException, BGPParsingException {
        this.register = new SimpleExtendedCommunityRegistry();
        this.register.registerExtendedCommunityParser(0, 0, this.parser);
        this.register.registerExtendedCommunitySerializer(RouteTargetIpv4Case.class, this.serializer);
        ((ExtendedCommunitySerializer)Mockito.doReturn((Object)0).when((Object)this.serializer)).getType(ArgumentMatchers.anyBoolean());
        ((ExtendedCommunitySerializer)Mockito.doReturn((Object)0).when((Object)this.serializer)).getSubType();
        ((ExtendedCommunitySerializer)Mockito.doNothing().when((Object)this.serializer)).serializeExtendedCommunity((ExtendedCommunity)ArgumentMatchers.any(ExtendedCommunity.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
        ((ExtendedCommunityParser)Mockito.doReturn(null).when((Object)this.parser)).parseExtendedCommunity((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test
    public void testExtendedCommunityRegistry() throws BGPDocumentedException, BGPParsingException {
        ByteBuf output = Unpooled.buffer();
        this.register.serializeExtendedCommunity(new ExtendedCommunitiesBuilder().setTransitive(Boolean.valueOf(true)).setExtendedCommunity((ExtendedCommunity)new RouteTargetIpv4CaseBuilder().setRouteTargetIpv4(new RouteTargetIpv4Builder().build()).build()).build(), output);
        ((ExtendedCommunitySerializer)Mockito.verify((Object)this.serializer)).serializeExtendedCommunity((ExtendedCommunity)ArgumentMatchers.any(ExtendedCommunity.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
        Assert.assertEquals((long)2L, (long)output.readableBytes());
        ExtendedCommunities parsedExtendedCommunity = this.register.parseExtendedCommunity(Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0}));
        ((ExtendedCommunityParser)Mockito.verify((Object)this.parser)).parseExtendedCommunity((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
        Assert.assertTrue((boolean)parsedExtendedCommunity.getTransitive());
        Assert.assertNull((Object)parsedExtendedCommunity.getExtendedCommunity());
    }

    @Test
    public void testExtendedCommunityRegistryUnknown() throws BGPDocumentedException, BGPParsingException {
        ByteBuf output = Unpooled.buffer();
        this.register.serializeExtendedCommunity(new ExtendedCommunitiesBuilder().setTransitive(Boolean.valueOf(false)).setExtendedCommunity((ExtendedCommunity)new RouteOriginIpv4CaseBuilder().build()).build(), output);
        Assert.assertEquals((long)0L, (long)output.readableBytes());
        ((ExtendedCommunitySerializer)Mockito.verify((Object)this.serializer, (VerificationMode)Mockito.never())).serializeExtendedCommunity((ExtendedCommunity)ArgumentMatchers.any(ExtendedCommunity.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
        ExtendedCommunities noExtCommunity = this.register.parseExtendedCommunity(Unpooled.copiedBuffer((byte[])new byte[]{0, 1, 0, 0, 0, 0, 0, 0}));
        Assert.assertNull((Object)noExtCommunity);
        ((ExtendedCommunityParser)Mockito.verify((Object)this.parser, (VerificationMode)Mockito.never())).parseExtendedCommunity((ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterParserOutOfRangeType() {
        this.register.registerExtendedCommunityParser(1234, 0, this.parser);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterParserOutOfRangeSubType() {
        this.register.registerExtendedCommunityParser(0, 1234, this.parser);
    }
}

