/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yangtools.binding.Notification;

public abstract class AbstractMessageRegistry
implements MessageRegistry {
    private static final byte[] MARKER = new byte[16];

    protected abstract Notification<?> parseBody(int var1, ByteBuf var2, int var3, PeerSpecificParserConstraint var4) throws BGPDocumentedException;

    protected abstract void serializeMessageImpl(Notification<?> var1, ByteBuf var2);

    @Override
    public Notification<?> parseMessage(ByteBuf buffer, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPParsingException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes cannot be null or empty.");
        Preconditions.checkArgument((buffer.readableBytes() >= 19 ? 1 : 0) != 0, (String)"Too few bytes in passed array. Passed: %s. Expected: >= %s.", (int)buffer.readableBytes(), (int)19);
        byte[] marker = ByteArray.readBytes((ByteBuf)buffer, (int)16);
        if (!Arrays.equals(marker, MARKER)) {
            throw new BGPDocumentedException("Marker not set to ones.", BGPError.CONNECTION_NOT_SYNC);
        }
        int messageLength = buffer.readUnsignedShort();
        byte typeBytes = buffer.readByte();
        int messageType = UnsignedBytes.toInt((byte)typeBytes);
        if (messageLength < 19) {
            throw BGPDocumentedException.badMessageLength((String)"Message length field not within valid range.", (int)messageLength);
        }
        if (messageLength - 19 != buffer.readableBytes()) {
            throw new BGPParsingException("Size doesn't match size specified in header. Passed: " + buffer.readableBytes() + "; Expected: " + (messageLength - 19) + ". ");
        }
        ByteBuf msgBody = buffer.readSlice(messageLength - 19);
        Notification<?> msg = this.parseBody(messageType, msgBody, messageLength, constraint);
        if (msg == null) {
            throw new BGPDocumentedException("Unhandled message type " + messageType, BGPError.BAD_MSG_TYPE, new byte[]{typeBytes});
        }
        return msg;
    }

    @Override
    public final void serializeMessage(Notification<?> message, ByteBuf buffer) {
        Objects.requireNonNull(message, "BGPMessage is mandatory.");
        this.serializeMessageImpl(message, buffer);
    }

    static {
        Arrays.fill(MARKER, (byte)-1);
    }
}

