/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.ParsedAttributes;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributesKey;
import org.opendaylight.yangtools.binding.DataContainer;
import org.opendaylight.yangtools.binding.util.BindingMap;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleAttributeRegistry
implements AttributeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAttributeRegistry.class);
    private static final int OPTIONAL_BIT = 0;
    private static final int TRANSITIVE_BIT = 1;
    private static final int PARTIAL_BIT = 2;
    private static final int EXTENDED_LENGTH_BIT = 3;
    private final HandlerRegistry<DataContainer, AttributeParser, AttributeSerializer> handlers = new HandlerRegistry();
    private final Map<Registration, AttributeSerializer> serializers = new LinkedHashMap<Registration, AttributeSerializer>();
    private final AtomicReference<Iterable<AttributeSerializer>> roSerializers = new AtomicReference<Collection<AttributeSerializer>>(this.serializers.values());
    private final List<UnrecognizedAttributes> unrecognizedAttributes = new ArrayList<UnrecognizedAttributes>();

    SimpleAttributeRegistry() {
    }

    Registration registerAttributeParser(int attributeType, AttributeParser parser) {
        Preconditions.checkArgument((attributeType >= 0 && attributeType <= 255 ? 1 : 0) != 0);
        return this.handlers.registerParser(attributeType, (Object)parser);
    }

    synchronized Registration registerAttributeSerializer(Class<? extends DataContainer> paramClass, AttributeSerializer serializer) {
        final Registration reg = this.handlers.registerSerializer(paramClass, (Object)serializer);
        this.serializers.put(reg, serializer);
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                SimpleAttributeRegistry simpleAttributeRegistry = SimpleAttributeRegistry.this;
                synchronized (simpleAttributeRegistry) {
                    SimpleAttributeRegistry.this.serializers.remove(reg);
                    SimpleAttributeRegistry.this.roSerializers.set(SimpleAttributeRegistry.this.serializers.values());
                }
                reg.close();
            }
        };
    }

    private void addAttribute(ByteBuf buffer, RevisedErrorHandling errorHandling, Map<Integer, RawAttribute> attributes) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        BitArray flags = BitArray.valueOf((byte)buffer.readByte());
        short type = buffer.readUnsignedByte();
        int len = flags.get(3) ? buffer.readUnsignedShort() : (int)buffer.readUnsignedByte();
        AttributeParser parser = (AttributeParser)this.handlers.getParser((int)type);
        if (attributes.containsKey(type)) {
            if (parser != null && !parser.ignoreDuplicates(errorHandling)) {
                throw new BGPDocumentedException("Duplicate attribute " + type, BGPError.MALFORMED_ATTR_LIST);
            }
            LOG.debug("Ignoring duplicate attribute type {}", (Object)type);
            return;
        }
        int readable = buffer.readableBytes();
        if (readable < len) {
            throw errorHandling.reportError(BGPError.MALFORMED_ATTR_LIST, "Attribute {} length {} cannot be satisfied, only {} bytes are left", type, len, readable);
        }
        if (parser == null) {
            this.processUnrecognized(flags, type, buffer, len);
        } else {
            attributes.put(Integer.valueOf(type), new RawAttribute(parser, buffer.readSlice(len)));
        }
    }

    private void processUnrecognized(BitArray flags, int type, ByteBuf buffer, int len) throws BGPDocumentedException {
        if (!flags.get(0)) {
            throw new BGPDocumentedException("Well known attribute not recognized.", BGPError.WELL_KNOWN_ATTR_NOT_RECOGNIZED);
        }
        Uint8 typeVal = Uint8.valueOf((int)type);
        UnrecognizedAttributes unrecognizedAttribute = new UnrecognizedAttributesBuilder().withKey(new UnrecognizedAttributesKey(typeVal)).setPartial(Boolean.valueOf(flags.get(2))).setTransitive(Boolean.valueOf(flags.get(1))).setType(typeVal).setValue(ByteArray.readBytes((ByteBuf)buffer, (int)len)).build();
        this.unrecognizedAttributes.add(unrecognizedAttribute);
        LOG.debug("Unrecognized attribute were parsed: {}", (Object)unrecognizedAttribute);
    }

    @Override
    public ParsedAttributes parseAttributes(ByteBuf buffer, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPParsingException {
        RevisedErrorHandling errorHandling = RevisedErrorHandling.from(constraint);
        TreeMap<Integer, RawAttribute> attributes = new TreeMap<Integer, RawAttribute>();
        BGPTreatAsWithdrawException withdrawCause = null;
        while (buffer.isReadable()) {
            try {
                this.addAttribute(buffer, errorHandling, attributes);
            }
            catch (BGPTreatAsWithdrawException e) {
                LOG.info("Failed to completely parse attributes list.");
                withdrawCause = e;
                break;
            }
        }
        AttributesBuilder builder = new AttributesBuilder();
        for (Map.Entry entry : attributes.entrySet()) {
            LOG.debug("Parsing attribute type {}", entry.getKey());
            RawAttribute a = (RawAttribute)entry.getValue();
            try {
                a.parser.parseAttribute(a.buffer, builder, errorHandling, constraint);
            }
            catch (BGPTreatAsWithdrawException e) {
                LOG.info("Attribute {} indicated treat-as-withdraw", entry.getKey(), (Object)e);
                if (withdrawCause == null) {
                    withdrawCause = e;
                    continue;
                }
                withdrawCause.addSuppressed((Throwable)e);
            }
        }
        builder.setUnrecognizedAttributes(BindingMap.ordered(this.unrecognizedAttributes));
        return new ParsedAttributes(builder.build(), withdrawCause);
    }

    @Override
    public void serializeAttribute(Attributes attribute, ByteBuf byteAggregator) {
        for (AttributeSerializer serializer : this.roSerializers.get()) {
            serializer.serializeAttribute(attribute, byteAggregator);
        }
    }

    private static final class RawAttribute {
        private final AttributeParser parser;
        private final ByteBuf buffer;

        RawAttribute(AttributeParser parser, ByteBuf buffer) {
            this.parser = Objects.requireNonNull(parser);
            this.buffer = Objects.requireNonNull(buffer);
        }
    }
}

