/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractMessageRegistry;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.KeepaliveBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;

public class AbstractMessageRegistryTest {
    public static final byte[] keepAliveBMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4};
    private final AbstractMessageRegistry registry = new AbstractMessageRegistry(){

        protected void serializeMessageImpl(Notification message, ByteBuf buffer) {
            buffer.writeBytes(keepAliveBMsg);
        }

        protected Notification parseBody(int type, ByteBuf body, int messageLength) throws BGPDocumentedException {
            return new KeepaliveBuilder().build();
        }
    };

    @Test
    public void testRegistry() throws BGPDocumentedException, BGPParsingException {
        Keepalive keepAlive = new KeepaliveBuilder().build();
        ByteBuf buffer = Unpooled.buffer();
        this.registry.serializeMessage((Notification)keepAlive, buffer);
        Assert.assertArrayEquals((byte[])keepAliveBMsg, (byte[])ByteArray.getAllBytes((ByteBuf)buffer));
        Notification not = this.registry.parseMessage(Unpooled.copiedBuffer((byte[])keepAliveBMsg));
        Assert.assertTrue((boolean)(not instanceof Keepalive));
    }

    @Test
    public void testIncompleteMarker() {
        byte[] testBytes = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4};
        try {
            this.registry.parseMessage(Unpooled.copiedBuffer((byte[])testBytes));
            Assert.fail();
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            Assert.assertTrue((boolean)(e instanceof BGPDocumentedException));
            Assert.assertEquals((Object)"Marker not set to ones.", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidLength() {
        byte[] testBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 18, 4};
        try {
            this.registry.parseMessage(Unpooled.copiedBuffer((byte[])testBytes));
            Assert.fail();
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            Assert.assertTrue((boolean)(e instanceof BGPDocumentedException));
            Assert.assertEquals((Object)"Message length field not within valid range.", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidSpecifiedSize() {
        byte[] testBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4, 4};
        try {
            this.registry.parseMessage(Unpooled.copiedBuffer((byte[])testBytes));
            Assert.fail();
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            Assert.assertTrue((boolean)(e instanceof BGPParsingException));
            Assert.assertTrue((boolean)e.getMessage().startsWith("Size doesn't match size specified in header."));
        }
    }
}

