/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractBGPExtensionProviderActivator;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.NlriParser;
import org.opendaylight.protocol.bgp.parser.spi.NlriSerializer;
import org.opendaylight.protocol.bgp.parser.spi.ParameterParser;
import org.opendaylight.protocol.bgp.parser.spi.ParameterSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.bgp.parameters.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.PathAttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.MpUnreachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;

public class BgpTestActivator
extends AbstractBGPExtensionProviderActivator {
    protected static final int TYPE = 0;
    private static final String EMPTY = "";
    @Mock
    protected AttributeSerializer attrSerializer;
    @Mock
    protected AttributeParser attrParser;
    @Mock
    protected ParameterParser paramParser;
    @Mock
    protected ParameterSerializer paramSerializer;
    @Mock
    protected CapabilityParser capaParser;
    @Mock
    protected CapabilitySerializer capaSerializer;
    @Mock
    protected MessageParser msgParser;
    @Mock
    protected MessageSerializer msgSerializer;
    @Mock
    protected NlriParser nlriParser;
    @Mock
    protected NlriSerializer nlriSerializer;

    protected List<AutoCloseable> startImpl(BGPExtensionProviderContext context) {
        this.initMock();
        ArrayList regs = Lists.newArrayList();
        regs.add(context.registerAttributeParser(0, this.attrParser));
        regs.add(context.registerAttributeSerializer(DataObject.class, this.attrSerializer));
        regs.add(context.registerParameterParser(0, this.paramParser));
        regs.add(context.registerParameterSerializer(BgpParameters.class, this.paramSerializer));
        regs.add(context.registerCapabilityParser(0, this.capaParser));
        regs.add(context.registerCapabilitySerializer(CParameters.class, this.capaSerializer));
        regs.add(context.registerMessageParser(0, this.msgParser));
        regs.add(context.registerMessageSerializer(Notification.class, this.msgSerializer));
        regs.add(context.registerAddressFamily(Ipv4AddressFamily.class, 1));
        regs.add(context.registerSubsequentAddressFamily(UnicastSubsequentAddressFamily.class, 1));
        regs.add(context.registerNlriParser(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class, this.nlriParser));
        regs.add(context.registerNlriSerializer(DataObject.class, this.nlriSerializer));
        return regs;
    }

    private void initMock() {
        MockitoAnnotations.initMocks((Object)((Object)this));
        try {
            ((AttributeParser)Mockito.doNothing().when((Object)this.attrParser)).parseAttribute((ByteBuf)Mockito.any(ByteBuf.class), (PathAttributesBuilder)Mockito.any(PathAttributesBuilder.class));
            ((AttributeParser)Mockito.doReturn((Object)EMPTY).when((Object)this.attrParser)).toString();
            ((AttributeSerializer)Mockito.doNothing().when((Object)this.attrSerializer)).serializeAttribute((DataObject)Mockito.any(DataObject.class), (ByteBuf)Mockito.any(ByteBuf.class));
            ((AttributeSerializer)Mockito.doReturn((Object)EMPTY).when((Object)this.attrSerializer)).toString();
            ((ParameterParser)Mockito.doReturn(null).when((Object)this.paramParser)).parseParameter((ByteBuf)Mockito.any(ByteBuf.class));
            ((ParameterParser)Mockito.doReturn((Object)EMPTY).when((Object)this.paramParser)).toString();
            ((ParameterSerializer)Mockito.doNothing().when((Object)this.paramSerializer)).serializeParameter((BgpParameters)Mockito.any(BgpParameters.class), (ByteBuf)Mockito.any(ByteBuf.class));
            ((ParameterSerializer)Mockito.doReturn((Object)EMPTY).when((Object)this.paramSerializer)).toString();
            ((CapabilityParser)Mockito.doReturn(null).when((Object)this.capaParser)).parseCapability((ByteBuf)Mockito.any(ByteBuf.class));
            ((CapabilityParser)Mockito.doReturn((Object)EMPTY).when((Object)this.capaParser)).toString();
            ((CapabilitySerializer)Mockito.doNothing().when((Object)this.capaSerializer)).serializeCapability((CParameters)Mockito.any(CParameters.class), (ByteBuf)Mockito.any(ByteBuf.class));
            ((CapabilitySerializer)Mockito.doReturn((Object)EMPTY).when((Object)this.capaSerializer)).toString();
            ((MessageParser)Mockito.doReturn((Object)Mockito.mock(Notification.class)).when((Object)this.msgParser)).parseMessageBody((ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt());
            ((MessageParser)Mockito.doReturn((Object)EMPTY).when((Object)this.msgParser)).toString();
            ((MessageSerializer)Mockito.doNothing().when((Object)this.msgSerializer)).serializeMessage((Notification)Mockito.any(Notification.class), (ByteBuf)Mockito.any(ByteBuf.class));
            ((MessageSerializer)Mockito.doReturn((Object)EMPTY).when((Object)this.msgSerializer)).toString();
            ((NlriParser)Mockito.doNothing().when((Object)this.nlriParser)).parseNlri((ByteBuf)Mockito.any(ByteBuf.class), (MpUnreachNlriBuilder)Mockito.any(MpUnreachNlriBuilder.class));
            ((NlriParser)Mockito.doNothing().when((Object)this.nlriParser)).parseNlri((ByteBuf)Mockito.any(ByteBuf.class), (MpReachNlriBuilder)Mockito.any(MpReachNlriBuilder.class));
            ((NlriParser)Mockito.doReturn((Object)EMPTY).when((Object)this.nlriParser)).toString();
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            Assert.fail();
        }
    }
}

