/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.concepts.AbstractRegistration;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.PathAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.PathAttributesBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleAttributeRegistry
implements AttributeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAttributeRegistry.class);
    private static final int OPTIONAL_BIT = 0;
    private static final int TRANSITIVE_BIT = 1;
    private static final int PARTIAL_BIT = 2;
    private static final int EXTENDED_LENGTH_BIT = 3;
    private final HandlerRegistry<DataContainer, AttributeParser, AttributeSerializer> handlers = new HandlerRegistry();
    private final Map<AbstractRegistration, AttributeSerializer> serializers = new LinkedHashMap<AbstractRegistration, AttributeSerializer>();
    private final AtomicReference<Iterable<AttributeSerializer>> roSerializers = new AtomicReference<Collection<AttributeSerializer>>(this.serializers.values());

    SimpleAttributeRegistry() {
    }

    AutoCloseable registerAttributeParser(int attributeType, AttributeParser parser) {
        Preconditions.checkArgument((attributeType >= 0 && attributeType <= 255 ? 1 : 0) != 0);
        return this.handlers.registerParser(attributeType, (Object)parser);
    }

    synchronized AutoCloseable registerAttributeSerializer(Class<? extends DataObject> paramClass, AttributeSerializer serializer) {
        final AbstractRegistration reg = this.handlers.registerSerializer(paramClass, (Object)serializer);
        this.serializers.put(reg, serializer);
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                SimpleAttributeRegistry simpleAttributeRegistry = SimpleAttributeRegistry.this;
                synchronized (simpleAttributeRegistry) {
                    SimpleAttributeRegistry.this.serializers.remove(reg);
                    SimpleAttributeRegistry.this.roSerializers.set(SimpleAttributeRegistry.this.serializers.values());
                }
                reg.close();
            }
        };
    }

    private void addAttribute(ByteBuf buffer, Map<Integer, RawAttribute> attributes) throws BGPDocumentedException {
        int len;
        boolean[] flags = ByteArray.parseBits((byte)buffer.readByte());
        short type = buffer.readUnsignedByte();
        int n = len = flags[3] ? buffer.readUnsignedShort() : (int)buffer.readUnsignedByte();
        if (!attributes.containsKey(type)) {
            AttributeParser parser = (AttributeParser)this.handlers.getParser((int)type);
            if (parser == null) {
                if (!flags[0]) {
                    throw new BGPDocumentedException("Well known attribute not recognized.", BGPError.WELL_KNOWN_ATTR_NOT_RECOGNIZED);
                }
                if (flags[1]) {
                    LOG.warn("Losing unrecognized transitive attribute {}", (Object)type);
                } else {
                    LOG.debug("Ignoring unrecognized attribute type {}", (Object)type);
                }
            } else {
                attributes.put(Integer.valueOf(type), new RawAttribute(parser, buffer.slice(buffer.readerIndex(), len)));
            }
        } else {
            LOG.debug("Ignoring duplicate attribute type {}", (Object)type);
        }
        buffer.skipBytes(len);
    }

    @Override
    public PathAttributes parseAttributes(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        TreeMap<Integer, RawAttribute> attributes = new TreeMap<Integer, RawAttribute>();
        while (buffer.isReadable()) {
            this.addAttribute(buffer, attributes);
        }
        PathAttributesBuilder builder = new PathAttributesBuilder();
        for (Map.Entry<Integer, RawAttribute> e : attributes.entrySet()) {
            LOG.debug("Parsing attribute type {}", (Object)e.getKey());
            RawAttribute a = e.getValue();
            a.parser.parseAttribute(a.buffer, builder);
        }
        return builder.build();
    }

    @Override
    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        for (AttributeSerializer serializer : this.roSerializers.get()) {
            serializer.serializeAttribute(attribute, byteAggregator);
        }
    }

    private static final class RawAttribute {
        private final AttributeParser parser;
        private final ByteBuf buffer;

        public RawAttribute(AttributeParser parser, ByteBuf buffer) {
            this.parser = (AttributeParser)Preconditions.checkNotNull((Object)parser);
            this.buffer = (ByteBuf)Preconditions.checkNotNull((Object)buffer);
        }
    }
}

