/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.NlriParser;
import org.opendaylight.protocol.bgp.parser.spi.NlriSerializer;
import org.opendaylight.protocol.bgp.parser.spi.ParameterParser;
import org.opendaylight.protocol.bgp.parser.spi.ParameterSerializer;
import org.opendaylight.protocol.bgp.parser.spi.pojo.SimpleBGPExtensionConsumerContext;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.bgp.parameters.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;

public class SimpleBGPExtensionProviderContext
extends SimpleBGPExtensionConsumerContext
implements BGPExtensionProviderContext {
    public static final int DEFAULT_MAXIMUM_CACHED_OBJECTS = 100000;
    private final AtomicReference<Cache<Object, Object>> cacheRef;
    private final ReferenceCache referenceCache = new ReferenceCache(){

        public <T> T getSharedReference(T object) {
            Cache cache = (Cache)SimpleBGPExtensionProviderContext.this.cacheRef.get();
            Object ret = cache.getIfPresent(object);
            if (ret == null) {
                cache.put(object, object);
                return object;
            }
            return (T)ret;
        }
    };
    private final int maximumCachedObjects;

    public SimpleBGPExtensionProviderContext() {
        this(100000);
    }

    public SimpleBGPExtensionProviderContext(int maximumCachedObjects) {
        this.maximumCachedObjects = maximumCachedObjects;
        Cache cache = CacheBuilder.newBuilder().maximumSize((long)maximumCachedObjects).build();
        this.cacheRef = new AtomicReference<Cache>(cache);
    }

    @Override
    public AutoCloseable registerAddressFamily(Class<? extends AddressFamily> clazz, int number) {
        return this.getAddressFamilyRegistry().registerAddressFamily(clazz, number);
    }

    @Override
    public AutoCloseable registerAttributeParser(int attributeType, AttributeParser parser) {
        return this.getAttributeRegistry().registerAttributeParser(attributeType, parser);
    }

    @Override
    public AutoCloseable registerAttributeSerializer(Class<? extends DataObject> attributeClass, AttributeSerializer serializer) {
        return this.getAttributeRegistry().registerAttributeSerializer(attributeClass, serializer);
    }

    @Override
    public AutoCloseable registerCapabilityParser(int capabilityType, CapabilityParser parser) {
        return this.getCapabilityRegistry().registerCapabilityParser(capabilityType, parser);
    }

    @Override
    public AutoCloseable registerCapabilitySerializer(Class<? extends CParameters> capabilityClass, CapabilitySerializer serializer) {
        return this.getCapabilityRegistry().registerCapabilitySerializer(capabilityClass, serializer);
    }

    @Override
    public AutoCloseable registerMessageParser(int messageType, MessageParser parser) {
        return this.getMessageRegistry().registerMessageParser(messageType, parser);
    }

    @Override
    public AutoCloseable registerMessageSerializer(Class<? extends Notification> messageClass, MessageSerializer serializer) {
        return this.getMessageRegistry().registerMessageSerializer(messageClass, serializer);
    }

    @Override
    public AutoCloseable registerNlriParser(Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi, NlriParser parser) {
        return this.getNlriRegistry().registerNlriParser(afi, safi, parser);
    }

    @Override
    public AutoCloseable registerNlriSerializer(Class<? extends DataObject> nlriClass, NlriSerializer serializer) {
        return this.getNlriRegistry().registerNlriSerializer(nlriClass, serializer);
    }

    @Override
    public AutoCloseable registerParameterParser(int parameterType, ParameterParser parser) {
        return this.getParameterRegistry().registerParameterParser(parameterType, parser);
    }

    @Override
    public AutoCloseable registerParameterSerializer(Class<? extends BgpParameters> paramClass, ParameterSerializer serializer) {
        return this.getParameterRegistry().registerParameterSerializer(paramClass, serializer);
    }

    @Override
    public AutoCloseable registerSubsequentAddressFamily(Class<? extends SubsequentAddressFamily> clazz, int number) {
        return this.getSubsequentAddressFamilyRegistry().registerSubsequentAddressFamily(clazz, number);
    }

    @Override
    public ReferenceCache getReferenceCache() {
        return this.referenceCache;
    }

    public final synchronized int getMaximumCachedObjects() {
        return this.maximumCachedObjects;
    }

    public final synchronized void setMaximumCachedObjects(int maximumCachedObjects) {
        Preconditions.checkArgument((maximumCachedObjects >= 0 ? 1 : 0) != 0);
        Cache newCache = CacheBuilder.newBuilder().maximumSize((long)maximumCachedObjects).build();
        newCache.putAll((Map)this.cacheRef.get().asMap());
        this.cacheRef.set((Cache<Object, Object>)newCache);
    }
}

