/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.bgp.concepts.NextHopUtil;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.NlriParser;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.NlriSerializer;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.concepts.AbstractRegistration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.MpUnreachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.MpUnreachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.CNextHop;
import org.opendaylight.yangtools.yang.binding.DataObject;

final class SimpleNlriRegistry
implements NlriRegistry {
    private static final int RESERVED = 1;
    private final ConcurrentMap<BgpTableType, NlriParser> handlers = new ConcurrentHashMap<BgpTableType, NlriParser>();
    private final ConcurrentMap<Class<? extends DataObject>, NlriSerializer> serializers = new ConcurrentHashMap<Class<? extends DataObject>, NlriSerializer>();
    private final SubsequentAddressFamilyRegistry safiReg;
    private final AddressFamilyRegistry afiReg;

    public SimpleNlriRegistry(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        this.afiReg = (AddressFamilyRegistry)Preconditions.checkNotNull((Object)afiReg);
        this.safiReg = (SubsequentAddressFamilyRegistry)Preconditions.checkNotNull((Object)safiReg);
    }

    private static BgpTableType createKey(Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi) {
        Preconditions.checkNotNull(afi);
        Preconditions.checkNotNull(safi);
        return new BgpTableTypeImpl(afi, safi);
    }

    synchronized AutoCloseable registerNlriSerializer(final Class<? extends DataObject> nlriClass, NlriSerializer serializer) {
        NlriSerializer prev = (NlriSerializer)this.serializers.get(nlriClass);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (Object)("Serializer already bound to class " + prev));
        this.serializers.put(nlriClass, serializer);
        final SimpleNlriRegistry lock = this;
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                Object object = lock;
                synchronized (object) {
                    SimpleNlriRegistry.this.serializers.remove(nlriClass);
                }
            }
        };
    }

    synchronized AutoCloseable registerNlriParser(Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi, NlriParser parser) {
        final BgpTableType key = SimpleNlriRegistry.createKey(afi, safi);
        NlriParser prev = (NlriParser)this.handlers.get(key);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (Object)("AFI/SAFI is already bound to parser " + prev));
        this.handlers.put(key, parser);
        final SimpleNlriRegistry lock = this;
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                Object object = lock;
                synchronized (object) {
                    SimpleNlriRegistry.this.handlers.remove(key);
                }
            }
        };
    }

    private Class<? extends AddressFamily> getAfi(ByteBuf buffer) throws BGPParsingException {
        int afiVal = buffer.readUnsignedShort();
        Class<? extends AddressFamily> afi = this.afiReg.classForFamily(afiVal);
        if (afi == null) {
            throw new BGPParsingException("Address Family Identifier: '" + afiVal + "' not supported.");
        }
        return afi;
    }

    private Class<? extends SubsequentAddressFamily> getSafi(ByteBuf buffer) throws BGPParsingException {
        int safiVal = UnsignedBytes.toInt((byte)buffer.readByte());
        Class<? extends SubsequentAddressFamily> safi = this.safiReg.classForFamily(safiVal);
        if (safi == null) {
            throw new BGPParsingException("Subsequent Address Family Identifier: '" + safiVal + "' not supported.");
        }
        return safi;
    }

    @Override
    public MpUnreachNlri parseMpUnreach(ByteBuf buffer) throws BGPParsingException {
        MpUnreachNlriBuilder builder = new MpUnreachNlriBuilder();
        builder.setAfi(this.getAfi(buffer));
        builder.setSafi(this.getSafi(buffer));
        NlriParser parser = (NlriParser)this.handlers.get(SimpleNlriRegistry.createKey(builder.getAfi(), builder.getSafi()));
        ByteBuf nlri = buffer.slice();
        parser.parseNlri(nlri, builder);
        return builder.build();
    }

    @Override
    public void serializeMpReach(MpReachNlri mpReachNlri, ByteBuf byteAggregator) {
        byteAggregator.writeShort(this.afiReg.numberForClass(mpReachNlri.getAfi()).intValue());
        byteAggregator.writeByte(this.safiReg.numberForClass(mpReachNlri.getSafi()).intValue());
        ByteBuf nextHopBuffer = Unpooled.buffer();
        NextHopUtil.serializeNextHop((CNextHop)mpReachNlri.getCNextHop(), (ByteBuf)nextHopBuffer);
        byteAggregator.writeByte(nextHopBuffer.writerIndex());
        byteAggregator.writeBytes(nextHopBuffer);
        byteAggregator.writeZero(1);
    }

    @Override
    public void serializeMpUnReach(MpUnreachNlri mpUnreachNlri, ByteBuf byteAggregator) {
        byteAggregator.writeShort(this.afiReg.numberForClass(mpUnreachNlri.getAfi()).intValue());
        byteAggregator.writeByte(this.safiReg.numberForClass(mpUnreachNlri.getSafi()).intValue());
    }

    @Override
    public Iterable<NlriSerializer> getSerializers() {
        return Iterables.unmodifiableIterable(this.serializers.values());
    }

    @Override
    public MpReachNlri parseMpReach(ByteBuf buffer) throws BGPParsingException {
        MpReachNlriBuilder builder = new MpReachNlriBuilder();
        builder.setAfi(this.getAfi(buffer));
        builder.setSafi(this.getSafi(buffer));
        NlriParser parser = (NlriParser)this.handlers.get(SimpleNlriRegistry.createKey(builder.getAfi(), builder.getSafi()));
        int nextHopLength = UnsignedBytes.toInt((byte)buffer.readByte());
        builder.setCNextHop(NextHopUtil.parseNextHop((ByteBuf)buffer.slice(buffer.readerIndex(), nextHopLength)));
        buffer.skipBytes(nextHopLength + 1);
        ByteBuf nlri = buffer.slice();
        parser.parseNlri(nlri, builder);
        return builder.build();
    }
}

