/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.bgp.parser.spi;

import java.util.List;
import javax.management.ObjectName;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.manager.impl.AbstractConfigTest;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HardcodedModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;
import org.opendaylight.controller.config.yang.bgp.parser.spi.SimpleBGPExtensionProviderContextModuleFactory;
import org.opendaylight.controller.config.yang.bgp.parser.spi.SimpleBGPExtensionProviderContextModuleMXBean;

public class SimpleBGPExtensionProviderContextModuleTest
extends AbstractConfigTest {
    private static final String FACTORY_NAME = "bgp-extensions-impl";
    private static final String INSTANCE_NAME = "bgp-extensions-impl";

    @Before
    public void setUp() throws Exception {
        super.initConfigTransactionManagerImpl((ModuleFactoriesResolver)new HardcodedModuleFactoriesResolver(this.mockedContext, new ModuleFactory[]{new SimpleBGPExtensionProviderContextModuleFactory()}));
    }

    @Test
    public void testCreateBean() throws Exception {
        CommitStatus status = this.createInstance();
        this.assertBeanCount(1, "bgp-extensions-impl");
        this.assertStatus(status, 1, 0, 0);
    }

    @Test
    public void testReusingOldInstance() throws Exception {
        this.createInstance();
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        this.assertBeanCount(1, "bgp-extensions-impl");
        CommitStatus status = transaction.commit();
        this.assertBeanCount(1, "bgp-extensions-impl");
        this.assertStatus(status, 0, 0, 1);
    }

    private CommitStatus createInstance() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        transaction.createModule("bgp-extensions-impl", "bgp-extensions-impl");
        return transaction.commit();
    }

    public static ObjectName createBGPExtensionsModuleInstance(ConfigTransactionJMXClient transaction, List<ObjectName> extensions) throws Exception {
        ObjectName objectName = transaction.createModule("bgp-extensions-impl", "bgp-extensions-impl");
        SimpleBGPExtensionProviderContextModuleMXBean mxBean = (SimpleBGPExtensionProviderContextModuleMXBean)transaction.newMXBeanProxy(objectName, SimpleBGPExtensionProviderContextModuleMXBean.class);
        mxBean.setExtension(extensions);
        return objectName;
    }
}

