/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityUtil;
import org.opendaylight.protocol.bgp.parser.spi.MessageUtil;
import org.opendaylight.protocol.bgp.parser.spi.ParameterUtil;
import org.opendaylight.protocol.util.ByteArray;

public class UtilsTest {
    @Test
    public void testCapabilityUtil() {
        byte[] result = new byte[]{1, 2, 4, 8};
        ByteBuf aggregator = Unpooled.buffer();
        CapabilityUtil.formatCapability((int)1, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{4, 8}), (ByteBuf)aggregator);
        Assert.assertArrayEquals((byte[])result, (byte[])ByteArray.getAllBytes((ByteBuf)aggregator));
    }

    @Test
    public void testMessageUtil() {
        byte[] result = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 23, 3, 32, 5, 14, 21};
        ByteBuf formattedMessage = Unpooled.buffer();
        MessageUtil.formatMessage((int)3, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{32, 5, 14, 21}), (ByteBuf)formattedMessage);
        Assert.assertArrayEquals((byte[])result, (byte[])ByteArray.getAllBytes((ByteBuf)formattedMessage));
    }

    @Test
    public void testParameterUtil() {
        byte[] result = new byte[]{1, 2, 4, 8};
        ByteBuf aggregator = Unpooled.buffer();
        ParameterUtil.formatParameter((int)1, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{4, 8}), (ByteBuf)aggregator);
        Assert.assertArrayEquals((byte[])result, (byte[])ByteArray.getAllBytes((ByteBuf)aggregator));
    }

    @Test
    public void testAttributeUtil() {
        byte[] result = new byte[]{64, 3, 4, 10, 0, 0, 2};
        ByteBuf aggregator = Unpooled.buffer();
        AttributeUtil.formatAttribute((int)64, (int)3, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{10, 0, 0, 2}), (ByteBuf)aggregator);
        Assert.assertArrayEquals((byte[])result, (byte[])ByteArray.getAllBytes((ByteBuf)aggregator));
    }

    @Test
    public void testAttributeUtilExtended() {
        byte[] value = new byte[258];
        Arrays.fill(value, 0, 258, (byte)-1);
        byte[] header = new byte[]{80, 3, 1, 2};
        byte[] result = new byte[262];
        System.arraycopy(header, 0, result, 0, header.length);
        System.arraycopy(value, 0, result, 4, value.length);
        ByteBuf aggregator = Unpooled.buffer();
        AttributeUtil.formatAttribute((int)64, (int)3, (ByteBuf)Unpooled.wrappedBuffer((byte[])value), (ByteBuf)aggregator);
        Assert.assertArrayEquals((byte[])result, (byte[])ByteArray.getAllBytes((ByteBuf)aggregator));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAttributeUtilPrivateConstructor() throws Throwable {
        Constructor c = AttributeUtil.class.getDeclaredConstructor(new Class[0]);
        c.setAccessible(true);
        try {
            c.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCapabilityUtilPrivateConstructor() throws Throwable {
        Constructor c = CapabilityUtil.class.getDeclaredConstructor(new Class[0]);
        c.setAccessible(true);
        try {
            c.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testMessageUtilPrivateConstructor() throws Throwable {
        Constructor c = MessageUtil.class.getDeclaredConstructor(new Class[0]);
        c.setAccessible(true);
        try {
            c.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testParameterUtilPrivateConstructor() throws Throwable {
        Constructor c = ParameterUtil.class.getDeclaredConstructor(new Class[0]);
        c.setAccessible(true);
        try {
            c.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

