/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityRegistry;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.NlriParser;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterParser;
import org.opendaylight.protocol.bgp.parser.spi.ParameterRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterSerializer;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.pojo.BgpTestActivator;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.attributes.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.attributes.MpUnreachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.attributes.MpUnreachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;

public class SimpleRegistryTest {
    protected BGPExtensionProviderContext ctx;
    private BgpTestActivator activator;

    @Before
    public void setUp() {
        this.ctx = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance();
        this.activator = new BgpTestActivator();
        this.activator.start(this.ctx);
    }

    @After
    public void tearDown() {
        this.activator.close();
    }

    @Test
    public void testSimpleAttribute() throws BGPDocumentedException, BGPParsingException {
        AttributeRegistry attrReg = this.ctx.getAttributeRegistry();
        byte[] attributeBytes = new byte[]{0, 0, 0};
        ByteBuf byteAggregator = Unpooled.buffer((int)attributeBytes.length);
        attrReg.serializeAttribute((DataObject)Mockito.mock(DataObject.class), byteAggregator);
        attrReg.parseAttributes(Unpooled.wrappedBuffer((byte[])attributeBytes));
        ((AttributeParser)Mockito.verify((Object)this.activator.attrParser, (VerificationMode)Mockito.times((int)1))).parseAttribute((ByteBuf)Mockito.any(ByteBuf.class), (AttributesBuilder)Mockito.any(AttributesBuilder.class));
        ((AttributeSerializer)Mockito.verify((Object)this.activator.attrSerializer, (VerificationMode)Mockito.times((int)1))).serializeAttribute((DataObject)Mockito.any(DataObject.class), (ByteBuf)Mockito.any(ByteBuf.class));
    }

    @Test
    public void testSimpleParameter() throws Exception {
        ParameterRegistry paramReg = this.ctx.getParameterRegistry();
        BgpParameters param = (BgpParameters)Mockito.mock(BgpParameters.class);
        ((BgpParameters)Mockito.doReturn(BgpParameters.class).when((Object)param)).getImplementedInterface();
        byte[] paramBytes = new byte[]{0, 0};
        ByteBuf buffer = Unpooled.buffer((int)paramBytes.length);
        paramReg.serializeParameter(param, buffer);
        paramReg.parseParameter(0, Unpooled.wrappedBuffer((byte[])paramBytes));
        ((ParameterParser)Mockito.verify((Object)this.activator.paramParser, (VerificationMode)Mockito.times((int)1))).parseParameter((ByteBuf)Mockito.any(ByteBuf.class));
        ((ParameterSerializer)Mockito.verify((Object)this.activator.paramSerializer, (VerificationMode)Mockito.times((int)1))).serializeParameter((BgpParameters)Mockito.any(BgpParameters.class), (ByteBuf)Mockito.any(ByteBuf.class));
    }

    @Test
    public void testSimpleCapability() throws Exception {
        CapabilityRegistry capaRegistry = this.ctx.getCapabilityRegistry();
        byte[] capabilityBytes = new byte[]{0, 0};
        CParameters capa = (CParameters)Mockito.mock(CParameters.class);
        ((CParameters)Mockito.doReturn(CParameters.class).when((Object)capa)).getImplementedInterface();
        ByteBuf buffer = Unpooled.buffer((int)capabilityBytes.length);
        capaRegistry.serializeCapability(capa, buffer);
        capaRegistry.parseCapability(0, Unpooled.wrappedBuffer((byte[])capabilityBytes));
        ((CapabilityParser)Mockito.verify((Object)this.activator.capaParser, (VerificationMode)Mockito.times((int)1))).parseCapability((ByteBuf)Mockito.any(ByteBuf.class));
        ((CapabilitySerializer)Mockito.verify((Object)this.activator.capaSerializer, (VerificationMode)Mockito.times((int)1))).serializeCapability((CParameters)Mockito.any(CParameters.class), (ByteBuf)Mockito.any(ByteBuf.class));
    }

    @Test
    public void testSimpleMessageRegistry() throws Exception {
        MessageRegistry msgRegistry = this.ctx.getMessageRegistry();
        byte[] msgBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 0};
        Notification msg = (Notification)Mockito.mock(Notification.class);
        ((Notification)Mockito.doReturn(Notification.class).when((Object)msg)).getImplementedInterface();
        ByteBuf buffer = Unpooled.buffer((int)msgBytes.length);
        msgRegistry.serializeMessage(msg, buffer);
        msgRegistry.parseMessage(Unpooled.wrappedBuffer((byte[])msgBytes));
        ((MessageParser)Mockito.verify((Object)this.activator.msgParser, (VerificationMode)Mockito.times((int)1))).parseMessageBody((ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt());
        ((MessageSerializer)Mockito.verify((Object)this.activator.msgSerializer, (VerificationMode)Mockito.times((int)1))).serializeMessage((Notification)Mockito.any(Notification.class), (ByteBuf)Mockito.any(ByteBuf.class));
    }

    @Test
    public void testAfiRegistry() throws Exception {
        AddressFamilyRegistry afiRegistry = this.ctx.getAddressFamilyRegistry();
        Assert.assertEquals(Ipv4AddressFamily.class, (Object)afiRegistry.classForFamily(1));
        Assert.assertEquals((long)1L, (long)afiRegistry.numberForClass(Ipv4AddressFamily.class).intValue());
    }

    @Test
    public void testSafiRegistry() throws Exception {
        SubsequentAddressFamilyRegistry safiRegistry = this.ctx.getSubsequentAddressFamilyRegistry();
        Assert.assertEquals(UnicastSubsequentAddressFamily.class, (Object)safiRegistry.classForFamily(1));
        Assert.assertEquals((long)1L, (long)safiRegistry.numberForClass(UnicastSubsequentAddressFamily.class).intValue());
    }

    @Test
    public void testMpReachParser() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpReachBytes = new byte[]{0, 1, 1, 4, 127, 0, 0, 1, 0};
        MpReachNlri mpReach = new MpReachNlriBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setCNextHop((CNextHop)new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("127.0.0.1")).build()).build()).build();
        ByteBuf buffer = Unpooled.buffer((int)mpReachBytes.length);
        nlriReg.serializeMpReach(mpReach, buffer);
        Assert.assertArrayEquals((byte[])mpReachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpReach, (Object)nlriReg.parseMpReach(Unpooled.wrappedBuffer((byte[])mpReachBytes)));
        ((NlriParser)Mockito.verify((Object)this.activator.nlriParser, (VerificationMode)Mockito.times((int)1))).parseNlri((ByteBuf)Mockito.any(ByteBuf.class), (MpReachNlriBuilder)Mockito.any(MpReachNlriBuilder.class));
    }

    @Test
    public void testMpReachWithZeroNextHop() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpReachBytes = new byte[]{0, 1, 1, 0, 0};
        MpReachNlri mpReach = new MpReachNlriBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build();
        ByteBuf buffer = Unpooled.buffer((int)mpReachBytes.length);
        nlriReg.serializeMpReach(mpReach, buffer);
        Assert.assertArrayEquals((byte[])mpReachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpReach, (Object)nlriReg.parseMpReach(Unpooled.wrappedBuffer((byte[])mpReachBytes)));
    }

    @Test
    public void testMpUnReachParser() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpUnreachBytes = new byte[]{0, 1, 1};
        MpUnreachNlri mpUnreach = new MpUnreachNlriBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build();
        ByteBuf buffer = Unpooled.buffer((int)mpUnreachBytes.length);
        nlriReg.serializeMpUnReach(mpUnreach, buffer);
        Assert.assertArrayEquals((byte[])mpUnreachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpUnreach, (Object)nlriReg.parseMpUnreach(Unpooled.wrappedBuffer((byte[])mpUnreachBytes)));
        ((NlriParser)Mockito.verify((Object)this.activator.nlriParser, (VerificationMode)Mockito.times((int)1))).parseNlri((ByteBuf)Mockito.any(ByteBuf.class), (MpUnreachNlriBuilder)Mockito.any(MpUnreachNlriBuilder.class));
    }
}

