/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import io.netty.buffer.Unpooled;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.pojo.SimpleAttributeRegistry;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.UnrecognizedAttributesKey;

public class UnrecognizedAttributesTest {
    private static final int UNRECOGNIZED_ATTRIBUTE_COUNT = 1;
    private static final int FIRST_ATTRIBUTE = 0;
    private static final short NON_EXISTENT_TYPE = 0;
    private static final int NON_VALUE_BYTES = 3;
    private static final SimpleAttributeRegistry simpleAttrReg = new SimpleAttributeRegistry();
    @Rule
    public ExpectedException expException = ExpectedException.none();

    @Test
    public void testUnrecognizedAttributesWithoutOptionalFlag() throws BGPDocumentedException, BGPParsingException {
        this.expException.expect(BGPDocumentedException.class);
        this.expException.expectMessage("Well known attribute not recognized.");
        simpleAttrReg.parseAttributes(Unpooled.wrappedBuffer((byte[])new byte[]{3, 0, 5, 1, 2, 3, 4, 5}));
    }

    @Test
    public void testUnrecognizedAttributes() throws BGPDocumentedException, BGPParsingException {
        byte[] attributeBytes = new byte[]{-32, 0, 5, 1, 2, 3, 4, 5};
        List unrecogAttribs = simpleAttrReg.parseAttributes(Unpooled.wrappedBuffer((byte[])attributeBytes)).getUnrecognizedAttributes();
        Assert.assertEquals((long)1L, (long)unrecogAttribs.size());
        UnrecognizedAttributes unrecogAttrib = (UnrecognizedAttributes)unrecogAttribs.get(0);
        UnrecognizedAttributesKey expectedAttribKey = new UnrecognizedAttributesKey(Short.valueOf(unrecogAttrib.getType()));
        Assert.assertTrue((boolean)unrecogAttrib.isPartial());
        Assert.assertTrue((boolean)unrecogAttrib.isTransitive());
        Assert.assertArrayEquals((byte[])ByteArray.cutBytes((byte[])attributeBytes, (int)3), (byte[])unrecogAttrib.getValue());
        Assert.assertEquals((long)0L, (long)unrecogAttrib.getType().shortValue());
        Assert.assertEquals((Object)expectedAttribKey, (Object)unrecogAttrib.getKey());
    }
}

