/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.protocol.concepts.AbstractRegistration;

abstract class AbstractFamilyRegistry<C, N> {
    private final Map<Class<? extends C>, N> classToNumber = new ConcurrentHashMap<Class<? extends C>, N>();
    private final Map<N, Class<? extends C>> numberToClass = new ConcurrentHashMap<N, Class<? extends C>>();

    AbstractFamilyRegistry() {
    }

    protected synchronized AutoCloseable registerFamily(final Class<? extends C> clazz, final N number) {
        Preconditions.checkNotNull(clazz);
        Class<? extends C> c = this.numberToClass.get(number);
        Preconditions.checkState((c == null ? 1 : 0) != 0, (String)"Number %s already registered to %s", (Object[])new Object[]{clazz, c});
        N n = this.classToNumber.get(clazz);
        Preconditions.checkState((n == null ? 1 : 0) != 0, (String)"Class %s already registered to %s", (Object[])new Object[]{clazz, n});
        this.numberToClass.put(number, clazz);
        this.classToNumber.put(clazz, number);
        final AbstractFamilyRegistry lock = this;
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                Object object = lock;
                synchronized (object) {
                    AbstractFamilyRegistry.this.classToNumber.remove(clazz);
                    AbstractFamilyRegistry.this.numberToClass.remove(number);
                }
            }
        };
    }

    protected Class<? extends C> classForFamily(N number) {
        return this.numberToClass.get(number);
    }

    protected N numberForClass(Class<? extends C> clazz) {
        return this.classToNumber.get(clazz);
    }
}

