/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityRegistry;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yangtools.yang.binding.DataContainer;

final class SimpleCapabilityRegistry
implements CapabilityRegistry {
    private final HandlerRegistry<DataContainer, CapabilityParser, CapabilitySerializer> handlers = new HandlerRegistry();

    SimpleCapabilityRegistry() {
    }

    AutoCloseable registerCapabilityParser(int messageType, CapabilityParser parser) {
        Preconditions.checkArgument((messageType >= 0 && messageType <= 255 ? 1 : 0) != 0);
        return this.handlers.registerParser(messageType, (Object)parser);
    }

    AutoCloseable registerCapabilitySerializer(Class<? extends CParameters> paramClass, CapabilitySerializer serializer) {
        return this.handlers.registerSerializer(paramClass, (Object)serializer);
    }

    @Override
    public CParameters parseCapability(int type, ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        CapabilityParser parser = (CapabilityParser)this.handlers.getParser(type);
        if (parser == null) {
            return null;
        }
        return parser.parseCapability(buffer);
    }

    @Override
    public void serializeCapability(CParameters capability, ByteBuf bytes) {
        CapabilitySerializer serializer = (CapabilitySerializer)this.handlers.getSerializer(capability.getImplementedInterface());
        if (serializer == null) {
            return;
        }
        serializer.serializeCapability(capability, bytes);
    }
}

