/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.bgp.parser.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.bgp.parser.spi.BGPExtensionProviderActivatorServiceInterface;
import org.opendaylight.controller.config.yang.bgp.parser.spi.BGPExtensionProviderContextServiceInterface;
import org.opendaylight.controller.config.yang.bgp.parser.spi.SimpleBGPExtensionProviderContextModuleMXBean;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderActivator;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2013-11-15", name="odl-bgp-parser-spi-cfg", namespace="urn:opendaylight:params:xml:ns:yang:controller:bgp:parser:spi")
public abstract class AbstractSimpleBGPExtensionProviderContextModule
extends AbstractModule<AbstractSimpleBGPExtensionProviderContextModule>
implements SimpleBGPExtensionProviderContextModuleMXBean,
BGPExtensionProviderContextServiceInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSimpleBGPExtensionProviderContextModule.class);
    public static final JmxAttribute extensionJmxAttribute = new JmxAttribute("Extension");
    private List<ObjectName> extension = new ArrayList<ObjectName>();
    private List<BGPExtensionProviderActivator> extensionDependency = new ArrayList<BGPExtensionProviderActivator>();

    public AbstractSimpleBGPExtensionProviderContextModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractSimpleBGPExtensionProviderContextModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractSimpleBGPExtensionProviderContextModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        for (ObjectName dep : this.extension) {
            this.dependencyResolver.validateDependency(BGPExtensionProviderActivatorServiceInterface.class, dep, extensionJmxAttribute);
        }
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final List<BGPExtensionProviderActivator> getExtensionDependency() {
        return this.extensionDependency;
    }

    protected final void resolveDependencies() {
        this.extensionDependency = new ArrayList<BGPExtensionProviderActivator>();
        for (ObjectName dep : this.extension) {
            this.extensionDependency.add((BGPExtensionProviderActivator)this.dependencyResolver.resolveInstance(BGPExtensionProviderActivator.class, dep, extensionJmxAttribute));
        }
    }

    public boolean canReuseInstance(AbstractSimpleBGPExtensionProviderContextModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractSimpleBGPExtensionProviderContextModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.extension, other.extension)) {
            return false;
        }
        for (int idx = 0; idx < this.extension.size(); ++idx) {
            if (this.dependencyResolver.canReuseDependency(this.extension.get(idx), extensionJmxAttribute)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSimpleBGPExtensionProviderContextModule that = (AbstractSimpleBGPExtensionProviderContextModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public List<ObjectName> getExtension() {
        return this.extension;
    }

    @Override
    @RequireInterface(value=BGPExtensionProviderActivatorServiceInterface.class)
    public void setExtension(List<ObjectName> extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Null not supported");
        }
        this.extension = extension;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

