/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.ParameterParser;
import org.opendaylight.protocol.bgp.parser.spi.ParameterRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterSerializer;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.BgpParameters;
import org.opendaylight.yangtools.yang.binding.DataContainer;

final class SimpleParameterRegistry
implements ParameterRegistry {
    private final HandlerRegistry<DataContainer, ParameterParser, ParameterSerializer> handlers = new HandlerRegistry();

    SimpleParameterRegistry() {
    }

    AutoCloseable registerParameterParser(int messageType, ParameterParser parser) {
        Preconditions.checkArgument((messageType >= 0 && messageType <= 255 ? 1 : 0) != 0);
        return this.handlers.registerParser(messageType, (Object)parser);
    }

    AutoCloseable registerParameterSerializer(Class<? extends BgpParameters> paramClass, ParameterSerializer serializer) {
        return this.handlers.registerSerializer(paramClass, (Object)serializer);
    }

    @Override
    public BgpParameters parseParameter(int parameterType, ByteBuf buffer) throws BGPParsingException, BGPDocumentedException {
        ParameterParser parser = (ParameterParser)this.handlers.getParser(parameterType);
        if (parser == null) {
            return null;
        }
        return parser.parseParameter(buffer);
    }

    @Override
    public void serializeParameter(BgpParameters parameter, ByteBuf bytes) {
        ParameterSerializer serializer = (ParameterSerializer)this.handlers.getSerializer(parameter.getImplementedInterface());
        if (serializer == null) {
            return;
        }
        serializer.serializeParameter(parameter, bytes);
    }
}

