/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.bgp.parser.spi.rev131115.modules.module.configuration.bgp.extensions.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.bgp.parser.spi.rev131115.modules.module.configuration.bgp.extensions.impl.Extension;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ExtensionBuilder
implements Builder<Extension> {
    private Object _name;
    private Class<? extends ServiceType> _type;
    Map<Class<? extends Augmentation<Extension>>, Augmentation<Extension>> augmentation = Collections.emptyMap();

    public ExtensionBuilder() {
    }

    public ExtensionBuilder(ServiceRef arg) {
        this._type = arg.getType();
        this._name = arg.getName();
    }

    public ExtensionBuilder(Extension base) {
        AugmentationHolder casted;
        this._name = base.getName();
        this._type = base.getType();
        if (base instanceof ExtensionImpl) {
            ExtensionImpl impl = (ExtensionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Extension>>, Augmentation<Extension>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Extension>>, Augmentation<Extension>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceRef) {
            this._type = ((ServiceRef)arg).getType();
            this._name = ((ServiceRef)arg).getName();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceRef] \nbut was: " + arg);
        }
    }

    public Object getName() {
        return this._name;
    }

    public Class<? extends ServiceType> getType() {
        return this._type;
    }

    public <E extends Augmentation<Extension>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ExtensionBuilder setName(Object value) {
        this._name = value;
        return this;
    }

    public ExtensionBuilder setType(Class<? extends ServiceType> value) {
        this._type = value;
        return this;
    }

    public ExtensionBuilder addAugmentation(Class<? extends Augmentation<Extension>> augmentationType, Augmentation<Extension> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Extension>>, Augmentation<Extension>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ExtensionBuilder removeAugmentation(Class<? extends Augmentation<Extension>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Extension build() {
        return new ExtensionImpl(this);
    }

    private static final class ExtensionImpl
    implements Extension {
        private final Object _name;
        private final Class<? extends ServiceType> _type;
        private Map<Class<? extends Augmentation<Extension>>, Augmentation<Extension>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Extension> getImplementedInterface() {
            return Extension.class;
        }

        private ExtensionImpl(ExtensionBuilder base) {
            this._name = base.getName();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Extension>>, Augmentation<Extension>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Extension>>, Augmentation<Extension>>(base.augmentation);
                }
            }
        }

        public Object getName() {
            return this._name;
        }

        public Class<? extends ServiceType> getType() {
            return this._type;
        }

        public <E extends Augmentation<Extension>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Extension.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Extension other = (Extension)obj;
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ExtensionImpl otherImpl = (ExtensionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Extension>>, Augmentation<Extension>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Extension [");
            boolean first = true;
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append(this._type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

