/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderActivator;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBGPExtensionProviderActivator
implements AutoCloseable,
BGPExtensionProviderActivator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBGPExtensionProviderActivator.class);
    @GuardedBy(value="this")
    private List<AutoCloseable> registrations;

    @GuardedBy(value="this")
    protected abstract List<AutoCloseable> startImpl(BGPExtensionProviderContext var1);

    @Override
    public final synchronized void start(BGPExtensionProviderContext context) {
        Preconditions.checkState((this.registrations == null ? 1 : 0) != 0);
        this.registrations = Objects.requireNonNull(this.startImpl(context));
    }

    @Override
    public final synchronized void stop() {
        if (this.registrations == null) {
            return;
        }
        for (AutoCloseable r : this.registrations) {
            try {
                r.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close registration", (Throwable)e);
            }
        }
        this.registrations = null;
    }

    @Override
    public final void close() {
        this.stop();
    }
}

