/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev171207.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev171207.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.Attributes1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.Attributes2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.update.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.update.attributes.MpUnreachNlri;

public final class MessageUtil {
    @VisibleForTesting
    public static final int MARKER_LENGTH = 16;
    @VisibleForTesting
    public static final int COMMON_HEADER_LENGTH = 19;
    private static final byte[] MARKER = new byte[16];

    private MessageUtil() {
        throw new UnsupportedOperationException();
    }

    public static void formatMessage(int type, ByteBuf body, ByteBuf buffer) {
        buffer.writeBytes(MARKER);
        buffer.writeShort(body.writerIndex() + 19);
        buffer.writeByte(type);
        buffer.writeBytes(body);
    }

    public static boolean isAnyNlriPresent(Update message) {
        if (message == null || message.getAttributes() == null) {
            return false;
        }
        List nlri = message.getNlri();
        return nlri != null && !nlri.isEmpty() || MessageUtil.getMpReachNlri(message.getAttributes()) != null;
    }

    public static MpReachNlri getMpReachNlri(Attributes attrs) {
        if (attrs != null && attrs.getAugmentation(Attributes1.class) != null) {
            return ((Attributes1)attrs.getAugmentation(Attributes1.class)).getMpReachNlri();
        }
        return null;
    }

    public static MpUnreachNlri getMpUnreachNlri(Attributes attrs) {
        if (attrs != null && attrs.getAugmentation(Attributes2.class) != null) {
            return ((Attributes2)attrs.getAugmentation(Attributes2.class)).getMpUnreachNlri();
        }
        return null;
    }

    static {
        Arrays.fill(MARKER, 0, 16, (byte)-1);
    }
}

