/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev171207.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev171207.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.mp.capabilities.RouteRefreshCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiprotocolCapabilitiesUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MultiprotocolCapabilitiesUtil.class);
    public static final CParameters RR_CAPABILITY = new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setRouteRefreshCapability(new RouteRefreshCapabilityBuilder().build()).build()).build();
    private static final int RESERVED = 1;

    private MultiprotocolCapabilitiesUtil() {
        throw new UnsupportedOperationException();
    }

    public static void serializeMPAfiSafi(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg, Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi, ByteBuf capBuffer) {
        Integer afival = afiReg.numberForClass(afi);
        Preconditions.checkArgument((afival != null ? 1 : 0) != 0, (Object)("Unhandled address family " + afi));
        capBuffer.writeShort(afival.intValue());
        capBuffer.writeZero(1);
        Integer safival = safiReg.numberForClass(safi);
        Preconditions.checkArgument((safival != null ? 1 : 0) != 0, (Object)("Unhandled subsequent address family " + safi));
        capBuffer.writeByte(safival.intValue());
    }

    public static Optional<BgpTableType> parseMPAfiSafi(ByteBuf buffer, AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        int afiVal = buffer.readUnsignedShort();
        Class<? extends AddressFamily> afi = afiReg.classForFamily(afiVal);
        if (afi == null) {
            LOG.info("Unsupported AFI {} parsed.", (Object)afiVal);
            return Optional.empty();
        }
        buffer.skipBytes(1);
        short safiVal = buffer.readUnsignedByte();
        Class<? extends SubsequentAddressFamily> safi = safiReg.classForFamily(safiVal);
        if (safi == null) {
            LOG.info("Unsupported SAFI {} parsed.", (Object)safiVal);
            return Optional.empty();
        }
        return Optional.of(new BgpTableTypeImpl(afi, safi));
    }
}

