/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev171207.PathId;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;

public final class PathIdUtil {
    public static final long NON_PATH_ID = 0L;

    private PathIdUtil() {
        throw new UnsupportedOperationException();
    }

    public static void writePathId(PathId pathId, ByteBuf buffer) {
        if (pathId != null && pathId.getValue() != 0L) {
            ByteBufWriteUtil.writeUnsignedInt((Long)pathId.getValue(), (ByteBuf)buffer);
        }
    }

    public static PathId readPathId(ByteBuf buffer) {
        Preconditions.checkArgument((buffer != null && buffer.isReadable(4) ? 1 : 0) != 0);
        return new PathId(Long.valueOf(buffer.readUnsignedInt()));
    }

    public static Long extractPathId(NormalizedNode<?, ?> data, YangInstanceIdentifier.NodeIdentifier pathNii) {
        return NormalizedNodes.findNode(data, (YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{pathNii}).map(NormalizedNode::getValue).orElse(null);
    }

    public static YangInstanceIdentifier.NodeIdentifierWithPredicates createNidKey(long pathId, YangInstanceIdentifier.PathArgument routeId, QName routeQname, QName pathidQname, QName routeKeyQname) {
        return PathIdUtil.createNodeIdentifierWithPredicates(routeQname, pathidQname, pathId, routeKeyQname, PathIdUtil.getObjectKey(routeId, routeKeyQname));
    }

    public static Object getObjectKey(YangInstanceIdentifier.PathArgument routeId, QName routeKeyQname) {
        return ((YangInstanceIdentifier.NodeIdentifierWithPredicates)routeId).getKeyValues().get(routeKeyQname);
    }

    public static YangInstanceIdentifier.NodeIdentifierWithPredicates createNodeIdentifierWithPredicates(QName routeQname, QName pathidQname, Object pathId, QName routeKeyQname, Object keyObject) {
        ImmutableMap keyValues = ImmutableMap.of((Object)pathidQname, (Object)pathId, (Object)routeKeyQname, (Object)keyObject);
        return new YangInstanceIdentifier.NodeIdentifierWithPredicates(routeQname, (Map)keyValues);
    }

    public static PathId buildPathId(DataContainerNode<? extends YangInstanceIdentifier.PathArgument> routesCont, YangInstanceIdentifier.NodeIdentifier pathIdNii) {
        Long pathIdVal = PathIdUtil.extractPathId(routesCont, pathIdNii);
        return pathIdVal == null ? null : new PathId(pathIdVal);
    }

    public static YangInstanceIdentifier.NodeIdentifierWithPredicates createNidKey(QName routeQname, QName routeKeyQname, QName pathIdQname, Object routeKeyValue, Optional<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> maybePathIdLeaf) {
        Long pathId = maybePathIdLeaf.isPresent() ? maybePathIdLeaf.get().getValue() : Long.valueOf(0L);
        return PathIdUtil.createNodeIdentifierWithPredicates(routeQname, pathIdQname, pathId, routeKeyQname, routeKeyValue);
    }
}

