/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupport;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.SendReceive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev171207.mp.capabilities.add.path.capability.AddressFamilies;

public final class MultiPathSupportImpl
implements MultiPathSupport {
    private final Set<BgpTableType> supportedTables;

    private MultiPathSupportImpl(Set<BgpTableType> supportedTables) {
        this.supportedTables = ImmutableSet.copyOf(supportedTables);
    }

    public static MultiPathSupport createParserMultiPathSupport(@Nonnull List<AddressFamilies> addPathCapabilities) {
        Objects.requireNonNull(addPathCapabilities);
        Set<BgpTableType> support = addPathCapabilities.stream().filter(e -> e.getSendReceive() == SendReceive.Both || e.getSendReceive() == SendReceive.Send).map(e -> new BgpTableTypeImpl(e.getAfi(), e.getSafi())).collect(Collectors.toSet());
        return new MultiPathSupportImpl(support);
    }

    @Override
    public boolean isTableTypeSupported(BgpTableType tableType) {
        return this.supportedTables.contains(tableType);
    }
}

