/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.protocol.bgp.parser.spi.PeerConstraint;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraintProvider;

public class PeerSpecificParserConstraintImpl
implements PeerSpecificParserConstraintProvider {
    @GuardedBy(value="this")
    private final Map<Class<? extends PeerConstraint>, PeerConstraint> constraints = new HashMap<Class<? extends PeerConstraint>, PeerConstraint>();

    @Override
    public synchronized <T extends PeerConstraint> Optional<T> getPeerConstraint(Class<T> peerConstraintType) {
        return Optional.ofNullable(this.constraints.get(peerConstraintType));
    }

    @Override
    public synchronized <T extends PeerConstraint> boolean addPeerConstraint(Class<T> classType, T peerConstraint) {
        Objects.requireNonNull(classType);
        Objects.requireNonNull(peerConstraint);
        PeerConstraint previous = this.constraints.putIfAbsent(classType, peerConstraint);
        return previous == null;
    }
}

