/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvParser;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvSerializer;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvUtil;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev171207.path.attributes.attributes.bgp.prefix.sid.bgp.prefix.sid.tlvs.BgpPrefixSidTlv;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public final class SimpleBgpPrefixSidTlvRegistry
implements BgpPrefixSidTlvRegistry {
    private final HandlerRegistry<DataContainer, BgpPrefixSidTlvParser, BgpPrefixSidTlvSerializer> handlers = new HandlerRegistry();

    AutoCloseable registerBgpPrefixSidTlvParser(int tlvType, BgpPrefixSidTlvParser parser) {
        Preconditions.checkArgument((tlvType >= 0 && tlvType <= 255 ? 1 : 0) != 0);
        return this.handlers.registerParser(tlvType, (Object)parser);
    }

    AutoCloseable registerBgpPrefixSidTlvSerializer(Class<? extends BgpPrefixSidTlv> tlvClass, BgpPrefixSidTlvSerializer serializer) {
        return this.handlers.registerSerializer(tlvClass, (Object)serializer);
    }

    @Override
    public BgpPrefixSidTlv parseBgpPrefixSidTlv(int type, ByteBuf buffer) {
        BgpPrefixSidTlvParser parser = (BgpPrefixSidTlvParser)this.handlers.getParser(type);
        if (parser == null) {
            return null;
        }
        int length = buffer.readUnsignedShort();
        Preconditions.checkState((length <= buffer.readableBytes() ? 1 : 0) != 0, (Object)"Length of BGP prefix SID TLV exceeds readable bytes of income.");
        return parser.parseBgpPrefixSidTlv(buffer.readBytes(length));
    }

    @Override
    public void serializeBgpPrefixSidTlv(BgpPrefixSidTlv tlv, ByteBuf bytes) {
        BgpPrefixSidTlvSerializer serializer = (BgpPrefixSidTlvSerializer)this.handlers.getSerializer(tlv.getImplementedInterface());
        if (serializer == null) {
            return;
        }
        ByteBuf valueBuf = Unpooled.buffer();
        serializer.serializeBgpPrefixSidTlv(tlv, valueBuf);
        BgpPrefixSidTlvUtil.formatBgpPrefixSidTlv(serializer.getType(), valueBuf, bytes);
    }
}

