/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractMessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.Notification;

final class SimpleMessageRegistry
extends AbstractMessageRegistry {
    private final HandlerRegistry<DataContainer, MessageParser, MessageSerializer> handlers = new HandlerRegistry();

    SimpleMessageRegistry() {
    }

    @Override
    protected Notification parseBody(int type, ByteBuf body, int messageLength, PeerSpecificParserConstraint constraint) throws BGPDocumentedException {
        MessageParser parser = (MessageParser)this.handlers.getParser(type);
        if (parser == null) {
            return null;
        }
        return parser.parseMessageBody(body, messageLength, constraint);
    }

    @Override
    protected void serializeMessageImpl(Notification message, ByteBuf buffer) {
        MessageSerializer serializer = (MessageSerializer)this.handlers.getSerializer(message.getImplementedInterface());
        if (serializer == null) {
            return;
        }
        serializer.serializeMessage(message, buffer);
    }

    AutoCloseable registerMessageParser(int messageType, MessageParser parser) {
        return this.handlers.registerParser(messageType, (Object)parser);
    }

    AutoCloseable registerMessageSerializer(Class<? extends Notification> messageClass, MessageSerializer serializer) {
        return this.handlers.registerSerializer(messageClass, (Object)serializer);
    }
}

