/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.mode.BesthPathStateUtil;
import org.opendaylight.protocol.bgp.mode.api.BestPathState;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunityUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpOrigin;
import org.opendaylight.yangtools.yang.common.Uint32;

public final class BestPathStateImpl
implements BestPathState {
    private final Attributes attributes;
    private long peerAs = 0L;
    private int asPathLength = 0;
    private Uint32 localPref;
    private long multiExitDisc;
    private BgpOrigin origin;
    private boolean depreferenced;
    private boolean resolved;

    public BestPathStateImpl(Attributes attributes) {
        this.attributes = Objects.requireNonNull(attributes);
        this.resolveValues();
    }

    private static int countAsPath(List<Segments> segments) {
        int count = 0;
        boolean setPresent = false;
        for (Segments s : segments) {
            if (s.getAsSet() != null && !setPresent) {
                setPresent = true;
                ++count;
                continue;
            }
            List seq = s.getAsSequence();
            if (seq == null) continue;
            count += seq.size();
        }
        return count;
    }

    private void resolveValues() {
        List attrCommunities;
        List segs;
        Uint32 med;
        if (this.resolved) {
            return;
        }
        LocalPref attrLocalPref = this.attributes.getLocalPref();
        this.localPref = attrLocalPref != null ? attrLocalPref.getPref() : null;
        MultiExitDisc attrMed = this.attributes.getMultiExitDisc();
        this.multiExitDisc = attrMed != null ? ((med = attrMed.getMed()) == null ? 0L : med.toJava()) : 0L;
        Origin attrOrigin = this.attributes.getOrigin();
        this.origin = attrOrigin != null ? attrOrigin.getValue() : null;
        AsPath attrAsPath = this.attributes.getAsPath();
        if (attrAsPath != null && (segs = attrAsPath.getSegments()) != null && !segs.isEmpty()) {
            this.peerAs = BesthPathStateUtil.getPeerAs(segs);
            this.asPathLength = BestPathStateImpl.countAsPath(segs);
        }
        this.depreferenced = (attrCommunities = this.attributes.getCommunities()) != null && attrCommunities.contains(CommunityUtil.LLGR_STALE);
        this.resolved = true;
    }

    @Override
    public Uint32 getLocalPref() {
        this.resolveValues();
        return this.localPref;
    }

    @Override
    public long getMultiExitDisc() {
        this.resolveValues();
        return this.multiExitDisc;
    }

    @Override
    public BgpOrigin getOrigin() {
        this.resolveValues();
        return this.origin;
    }

    @Override
    public long getPeerAs() {
        this.resolveValues();
        return this.peerAs;
    }

    @Override
    public int getAsPathLength() {
        this.resolveValues();
        return this.asPathLength;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isDepreferenced() {
        this.resolveValues();
        return this.depreferenced;
    }

    private MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("attributes", (Object)this.attributes);
        toStringHelper.add("localPref", (Object)this.localPref);
        toStringHelper.add("multiExitDisc", this.multiExitDisc);
        toStringHelper.add("origin", (Object)this.origin);
        toStringHelper.add("resolved", this.resolved);
        toStringHelper.add("depreferenced", this.depreferenced);
        return toStringHelper;
    }

    public String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + (this.localPref == null ? 0 : this.localPref.hashCode());
        result = 31 * result + Long.hashCode(this.multiExitDisc);
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + Boolean.hashCode(this.depreferenced);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BestPathStateImpl)) {
            return false;
        }
        BestPathStateImpl other = (BestPathStateImpl)obj;
        if (!this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.localPref == null ? other.localPref != null : !this.localPref.equals(other.localPref)) {
            return false;
        }
        if (this.multiExitDisc != other.multiExitDisc) {
            return false;
        }
        if (this.origin != other.origin) {
            return false;
        }
        return this.depreferenced == other.depreferenced;
    }
}

