/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.add;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opendaylight.protocol.bgp.mode.api.RouteEntry;
import org.opendaylight.protocol.bgp.mode.impl.BestPathStateImpl;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathBestPath;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathSelector;
import org.opendaylight.protocol.bgp.mode.impl.add.RouteKey;
import org.opendaylight.protocol.bgp.mode.impl.add.RouteKeyOffsets;
import org.opendaylight.protocol.bgp.parser.spi.PathIdUtil;
import org.opendaylight.protocol.bgp.rib.spi.RIBSupport;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.protocol.bgp.rib.spi.entry.ActualBestPathRoutes;
import org.opendaylight.protocol.bgp.rib.spi.entry.AdvertizedRoute;
import org.opendaylight.protocol.bgp.rib.spi.entry.RouteEntryInfo;
import org.opendaylight.protocol.bgp.rib.spi.entry.StaleBestPathRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Route;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.tables.Routes;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AddPathAbstractRouteEntry<C extends Routes & DataObject, S extends ChildOf<? super C>, R extends Route & ChildOf<? super S>, I extends Identifier<R>>
implements RouteEntry<C, S, R, I> {
    private static final Logger LOG = LoggerFactory.getLogger(AddPathAbstractRouteEntry.class);
    private static final Uint32[] EMPTY_PATHS_ID = new Uint32[0];
    private static final Route[] EMPTY_VALUES = new Route[0];
    private RouteKeyOffsets offsets = RouteKeyOffsets.EMPTY;
    private R[] values = EMPTY_VALUES;
    private Uint32[] pathsId = EMPTY_PATHS_ID;
    private List<AddPathBestPath> bestPath;
    private List<AddPathBestPath> bestPathRemoved;
    private List<AddPathBestPath> newBestPathToBeAdvertised;
    private List<Uint32> removedPathsId;
    private long pathIdCounter = 0L;
    private boolean isNonAddPathBestPathNew;

    private R createRoute(RIBSupport<C, S, R, I> ribSup, String routeKey, AddPathBestPath path) {
        RouteKeyOffsets map = this.offsets;
        Route route = (Route)map.getValue(this.values, map.offsetOf(path.getRouteKey()));
        return (R)ribSup.createRoute(route, ribSup.createRouteListKey(AddPathAbstractRouteEntry.pathIdObj(path.getPathIdLong()), routeKey), path.getAttributes());
    }

    @Override
    public final int addRoute(RouterId routerId, Uint32 remotePathId, R route) {
        RouteKey key = new RouteKey(routerId, remotePathId);
        int offset = this.offsets.offsetOf(key);
        if (offset < 0) {
            RouteKeyOffsets newOffsets = (RouteKeyOffsets)this.offsets.with(key);
            offset = newOffsets.offsetOf(key);
            Route[] newRoute = (Route[])newOffsets.expand(this.offsets, this.values, offset);
            Uint32[] newPathsId = newOffsets.expand(this.offsets, this.pathsId, offset);
            this.values = newRoute;
            this.offsets = newOffsets;
            this.pathsId = newPathsId;
            this.offsets.setValue(this.pathsId, offset, Uint32.valueOf((long)(++this.pathIdCounter)));
        }
        this.offsets.setValue(this.values, offset, route);
        LOG.trace("Added route {} from {}", route, (Object)routerId);
        return offset;
    }

    @Override
    public final boolean removeRoute(RouterId routerId, Uint32 remotePathId) {
        RouteKey key = new RouteKey(routerId, remotePathId);
        int offset = this.offsets.offsetOf(key);
        Uint32 pathId = this.offsets.getValue(this.pathsId, offset);
        this.values = this.offsets.removeValue(this.values, offset, EMPTY_VALUES);
        this.pathsId = this.offsets.removeValue(this.pathsId, offset, EMPTY_PATHS_ID);
        this.offsets = (RouteKeyOffsets)this.offsets.without(key);
        if (this.removedPathsId == null) {
            this.removedPathsId = new ArrayList<Uint32>();
        }
        this.removedPathsId.add(pathId);
        return this.offsets.isEmpty();
    }

    @Override
    public final Optional<StaleBestPathRoute<C, S, R, I>> removeStalePaths(RIBSupport<C, S, R, I> ribSupport, String routeKey) {
        List removedPaths;
        List<PathId> stalePaths;
        if (this.bestPathRemoved != null && !this.bestPathRemoved.isEmpty()) {
            stalePaths = this.bestPathRemoved.stream().map(AddPathBestPath::getPathIdLong).map(AddPathAbstractRouteEntry::pathIdObj).collect(Collectors.toList());
            this.bestPathRemoved = null;
        } else {
            stalePaths = Collections.emptyList();
        }
        if (this.removedPathsId != null) {
            removedPaths = Lists.transform(this.removedPathsId, AddPathAbstractRouteEntry::pathIdObj);
            this.removedPathsId = null;
        } else {
            removedPaths = Collections.emptyList();
        }
        return stalePaths.isEmpty() && removedPaths.isEmpty() ? Optional.empty() : Optional.of(new Stale<C, S, R, I>(ribSupport, routeKey, stalePaths, removedPaths, this.isNonAddPathBestPathNew));
    }

    @Override
    public final List<AdvertizedRoute<C, S, R, I>> newBestPaths(RIBSupport<C, S, R, I> ribSupport, String routeKey) {
        if (this.newBestPathToBeAdvertised == null || this.newBestPathToBeAdvertised.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AdvertizedRoute<C, S, R, I>> advertized = new ArrayList<AdvertizedRoute<C, S, R, I>>(this.newBestPathToBeAdvertised.size());
        AddPathBestPath firstBestPath = this.bestPath.isEmpty() ? null : this.bestPath.get(0);
        for (AddPathBestPath path : this.newBestPathToBeAdvertised) {
            R routeAddPath = this.createRoute(ribSupport, routeKey, path);
            boolean isFirstBestPath = firstBestPath != null && firstBestPath.equals(path);
            AdvertizedRoute adv = new AdvertizedRoute(ribSupport, isFirstBestPath, routeAddPath, path.getAttributes(), path.getPeerId(), path.isDepreferenced());
            advertized.add(adv);
        }
        this.newBestPathToBeAdvertised = null;
        return advertized;
    }

    @Override
    public final List<ActualBestPathRoutes<C, S, R, I>> actualBestPaths(RIBSupport<C, S, R, I> ribSupport, RouteEntryInfo entryInfo) {
        if (this.bestPath == null || this.bestPath.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ActualBestPathRoutes<C, S, R, I>> preexistentRoutes = new ArrayList<ActualBestPathRoutes<C, S, R, I>>();
        for (AddPathBestPath path : this.bestPath) {
            R route = this.createRoute(ribSupport, entryInfo.getRouteKey(), path);
            ActualBestPathRoutes adv = new ActualBestPathRoutes(ribSupport, route, path.getPeerId(), path.getAttributes(), path.isDepreferenced());
            preexistentRoutes.add(adv);
        }
        return preexistentRoutes;
    }

    @Override
    public final boolean selectBest(long localAs) {
        int size = this.offsets.size();
        return this.isBestPathNew(size == 0 ? ImmutableList.of() : this.selectBest(localAs, size));
    }

    protected abstract ImmutableList<AddPathBestPath> selectBest(long var1, int var3);

    protected final void processOffset(AddPathSelector selector, int offset) {
        RouteKey key = (RouteKey)this.offsets.getKey(offset);
        Route route = (Route)this.offsets.getValue(this.values, offset);
        Uint32 pathId = this.offsets.getValue(this.pathsId, offset);
        LOG.trace("Processing router key {} route {}", (Object)key, (Object)route);
        selector.processPath(route.getAttributes(), key, offset, pathId);
    }

    protected final AddPathBestPath bestPathAt(int offset) {
        Route route = (Route)Verify.verifyNotNull((Object)((Route)this.offsets.getValue(this.values, offset)));
        return new AddPathBestPath(new BestPathStateImpl(route.getAttributes()), (RouteKey)this.offsets.getKey(offset), this.offsets.getValue(this.pathsId, offset), offset);
    }

    private boolean isBestPathNew(ImmutableList<AddPathBestPath> newBestPathList) {
        this.isNonAddPathBestPathNew = !this.isNonAddPathBestPathTheSame((List<AddPathBestPath>)newBestPathList);
        this.filterRemovedPaths((List<AddPathBestPath>)newBestPathList);
        if (this.bestPathRemoved != null && !this.bestPathRemoved.isEmpty() || newBestPathList != null && !newBestPathList.equals(this.bestPath)) {
            if (this.bestPath != null) {
                this.newBestPathToBeAdvertised = new ArrayList<AddPathBestPath>((Collection<AddPathBestPath>)newBestPathList);
                this.newBestPathToBeAdvertised.removeAll(this.bestPath);
            } else {
                this.newBestPathToBeAdvertised = newBestPathList;
            }
            this.bestPath = newBestPathList;
            LOG.trace("Actual Best {}, removed best {}", this.bestPath, this.bestPathRemoved);
            return true;
        }
        return false;
    }

    private boolean isNonAddPathBestPathTheSame(List<AddPathBestPath> newBestPathList) {
        return !AddPathAbstractRouteEntry.isEmptyOrNull(this.bestPath) && !AddPathAbstractRouteEntry.isEmptyOrNull(newBestPathList) && this.bestPath.get(0).equals(newBestPathList.get(0));
    }

    private static boolean isEmptyOrNull(List<AddPathBestPath> pathList) {
        return pathList == null || pathList.isEmpty();
    }

    private void filterRemovedPaths(List<AddPathBestPath> newBestPathList) {
        if (this.bestPath == null) {
            return;
        }
        this.bestPathRemoved = new ArrayList<AddPathBestPath>(this.bestPath);
        this.bestPath.forEach(oldBest -> {
            Optional<AddPathBestPath> present = newBestPathList.stream().filter(newBest -> newBest.getPathId() == oldBest.getPathId() && newBest.getRouteKey() == oldBest.getRouteKey()).findAny();
            present.ifPresent(addPathBestPath -> this.bestPathRemoved.remove(oldBest));
        });
    }

    private static PathId pathIdObj(Uint32 pathId) {
        return PathIdUtil.NON_PATH_ID_VALUE.equals(pathId) ? PathIdUtil.NON_PATH_ID : new PathId(pathId);
    }

    private static final class Stale<C extends Routes & DataObject, S extends ChildOf<? super C>, R extends Route & ChildOf<? super S>, I extends Identifier<R>>
    extends StaleBestPathRoute<C, S, R, I> {
        private final List<I> addPathRouteKeyIdentifier;
        private final List<I> staleRouteKeyIdentifier;
        private final boolean isNonAddPathBestPathNew;

        Stale(RIBSupport<C, S, R, I> ribSupport, String routeKey, List<PathId> staleRoutesPathIds, List<PathId> withdrawalRoutePathIds, boolean isNonAddPathBestPathNew) {
            super(ribSupport.createRouteListKey(routeKey));
            this.isNonAddPathBestPathNew = isNonAddPathBestPathNew;
            this.staleRouteKeyIdentifier = staleRoutesPathIds.stream().map(pathId -> ribSupport.createRouteListKey(pathId, routeKey)).collect(Collectors.toList());
            this.addPathRouteKeyIdentifier = withdrawalRoutePathIds != null ? withdrawalRoutePathIds.stream().map(pathId -> ribSupport.createRouteListKey(pathId, routeKey)).collect(Collectors.toList()) : Collections.emptyList();
        }

        public List<I> getStaleRouteKeyIdentifiers() {
            return this.staleRouteKeyIdentifier;
        }

        public List<I> getAddPathRouteKeyIdentifiers() {
            return this.addPathRouteKeyIdentifier;
        }

        public boolean isNonAddPathBestPathNew() {
            return this.isNonAddPathBestPathNew;
        }
    }
}

