/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.add;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.bgp.mode.api.BestPathState;
import org.opendaylight.protocol.bgp.mode.impl.add.RouteKey;
import org.opendaylight.protocol.bgp.mode.spi.AbstractBestPath;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.yangtools.yang.common.Uint32;

public final class AddPathBestPath
extends AbstractBestPath {
    private final @NonNull RouteKey routeKey;
    private final @NonNull Uint32 pathId;
    private final int offset;

    AddPathBestPath(@NonNull BestPathState state, @NonNull RouteKey key, @NonNull Uint32 pathId, int offset) {
        super(state);
        this.routeKey = Objects.requireNonNull(key);
        this.pathId = Objects.requireNonNull(pathId);
        this.offset = offset;
    }

    RouteKey getRouteKey() {
        return this.routeKey;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper.add("routeKey", (Object)this.routeKey).add("pathId", (Object)this.pathId).add("offset", this.offset));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.routeKey.hashCode();
        result = 31 * result + this.state.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AddPathBestPath)) {
            return false;
        }
        AddPathBestPath other = (AddPathBestPath)obj;
        if (!this.routeKey.equals(other.routeKey)) {
            return false;
        }
        if (!this.state.equals(other.state)) {
            return false;
        }
        return this.pathId.equals(other.pathId);
    }

    @Override
    public RouterId getRouterId() {
        return this.routeKey.getRouterId();
    }

    @Override
    public long getPathId() {
        return this.pathId.longValue();
    }

    @NonNull Uint32 getPathIdLong() {
        return this.pathId;
    }
}

