/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.add;

import org.opendaylight.protocol.bgp.mode.impl.BestPathStateImpl;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathBestPath;
import org.opendaylight.protocol.bgp.mode.impl.add.RouteKey;
import org.opendaylight.protocol.bgp.mode.spi.AbstractBestPathSelector;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddPathSelector
extends AbstractBestPathSelector {
    private static final Logger LOG = LoggerFactory.getLogger(AddPathSelector.class);
    private RouteKey bestRouteKey;
    private Uint32 bestPathId;
    private int bestOffset;

    public AddPathSelector(long ourAs) {
        super(ourAs);
    }

    void processPath(Attributes attrs, RouteKey key, int offsetPosition, Uint32 pathId) {
        if (attrs != null) {
            RouterId routerId = key.getRouterId();
            RouterId originatorId = this.replaceOriginator(routerId, attrs.getOriginatorId());
            BestPathStateImpl state = new BestPathStateImpl(attrs);
            if (this.bestOriginatorId == null || !this.isExistingPathBetter(state)) {
                LOG.trace("Selecting path from router {}", (Object)routerId);
                this.bestOriginatorId = originatorId;
                this.bestState = state;
                this.bestRouteKey = key;
                this.bestOffset = offsetPosition;
                this.bestPathId = pathId;
            }
        }
    }

    public AddPathBestPath result() {
        return this.bestRouteKey == null ? null : new AddPathBestPath(this.bestState, this.bestRouteKey, this.bestPathId, this.bestOffset);
    }
}

