/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.base;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.bgp.mode.api.BestPathState;
import org.opendaylight.protocol.bgp.mode.spi.AbstractBestPath;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;

final class BaseBestPath
extends AbstractBestPath {
    private final @NonNull RouterId routerId;

    BaseBestPath(@NonNull RouterId routerId, @NonNull BestPathState state) {
        super(state);
        this.routerId = Objects.requireNonNull(routerId);
    }

    @Override
    public RouterId getRouterId() {
        return this.routerId;
    }

    @Override
    public long getPathId() {
        return 0L;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper.add("routerId", (Object)this.routerId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.routerId.hashCode();
        result = 31 * result + this.state.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BaseBestPath)) {
            return false;
        }
        BaseBestPath other = (BaseBestPath)obj;
        return this.routerId.equals((Object)other.routerId) && this.state.equals(other.state);
    }
}

