/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.base;

import java.util.Objects;
import org.opendaylight.protocol.bgp.mode.impl.BestPathStateImpl;
import org.opendaylight.protocol.bgp.mode.impl.base.BaseBestPath;
import org.opendaylight.protocol.bgp.mode.spi.AbstractBestPathSelector;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BasePathSelector
extends AbstractBestPathSelector {
    private static final Logger LOG = LoggerFactory.getLogger(BasePathSelector.class);
    private RouterId bestRouterId = null;

    BasePathSelector(long ourAs) {
        super(ourAs);
    }

    void processPath(RouterId routerId, Attributes attrs) {
        Objects.requireNonNull(routerId, "Router ID may not be null");
        if (attrs != null) {
            RouterId originatorId = this.replaceOriginator(routerId, attrs.getOriginatorId());
            BestPathStateImpl state = new BestPathStateImpl(attrs);
            if (this.bestOriginatorId == null || !this.isExistingPathBetter(state)) {
                LOG.trace("Selecting path from router {}", (Object)routerId);
                this.bestOriginatorId = originatorId;
                this.bestRouterId = routerId;
                this.bestState = state;
            }
        }
    }

    BaseBestPath result() {
        return this.bestRouterId == null ? null : new BaseBestPath(this.bestRouterId, this.bestState);
    }
}

