/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.base;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.opendaylight.protocol.bgp.mode.api.RouteEntry;
import org.opendaylight.protocol.bgp.mode.impl.base.BaseBestPath;
import org.opendaylight.protocol.bgp.mode.impl.base.BasePathSelector;
import org.opendaylight.protocol.bgp.mode.impl.base.RouterIdOffsets;
import org.opendaylight.protocol.bgp.rib.spi.RIBSupport;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.protocol.bgp.rib.spi.entry.ActualBestPathRoutes;
import org.opendaylight.protocol.bgp.rib.spi.entry.AdvertizedRoute;
import org.opendaylight.protocol.bgp.rib.spi.entry.RouteEntryInfo;
import org.opendaylight.protocol.bgp.rib.spi.entry.StaleBestPathRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Route;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.tables.Routes;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BaseRouteEntry<C extends Routes & DataObject, S extends ChildOf<? super C>, R extends Route & ChildOf<? super S>, I extends Identifier<R>>
implements RouteEntry<C, S, R, I> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRouteEntry.class);
    private static final Route[] EMPTY_VALUES = new Route[0];
    private RouterIdOffsets offsets = RouterIdOffsets.EMPTY;
    private R[] values = EMPTY_VALUES;
    private BaseBestPath bestPath;
    private BaseBestPath removedBestPath;

    BaseRouteEntry() {
    }

    @Override
    public boolean removeRoute(RouterId routerId, Uint32 remotePathId) {
        int offset = this.offsets.offsetOf(routerId);
        this.values = this.offsets.removeValue(this.values, offset, EMPTY_VALUES);
        this.offsets = (RouterIdOffsets)this.offsets.without(routerId);
        return this.offsets.isEmpty();
    }

    private R createRoute(RIBSupport<C, S, R, I> ribSup, String routeKey) {
        Identifier key = ribSup.createRouteListKey(routeKey);
        Route route = (Route)this.offsets.getValue(this.values, this.offsets.offsetOf(this.bestPath.getRouterId()));
        return (R)ribSup.createRoute(route, key, this.bestPath.getAttributes());
    }

    @Override
    public boolean selectBest(long localAs) {
        boolean modified;
        BasePathSelector selector = new BasePathSelector(localAs);
        for (int i = 0; i < this.offsets.size(); ++i) {
            RouterId routerId = (RouterId)this.offsets.getKey(i);
            Attributes attributes = ((Route)this.offsets.getValue(this.values, i)).getAttributes();
            LOG.trace("Processing router id {} attributes {}", (Object)routerId, (Object)attributes);
            selector.processPath(routerId, attributes);
        }
        BaseBestPath newBestPath = selector.result();
        boolean bl = modified = newBestPath == null || !newBestPath.equals(this.bestPath);
        if (modified) {
            if (this.offsets.isEmpty()) {
                this.removedBestPath = this.bestPath;
            }
            LOG.trace("Previous best {}, current best {}", (Object)this.bestPath, (Object)newBestPath);
            this.bestPath = newBestPath;
        }
        return modified;
    }

    @Override
    public int addRoute(RouterId routerId, Uint32 remotePathId, R route) {
        int offset = this.offsets.offsetOf(routerId);
        if (offset < 0) {
            RouterIdOffsets newOffsets = (RouterIdOffsets)this.offsets.with(routerId);
            offset = newOffsets.offsetOf(routerId);
            this.values = (Route[])newOffsets.expand(this.offsets, this.values, offset);
            this.offsets = newOffsets;
        }
        this.offsets.setValue(this.values, offset, route);
        LOG.trace("Added route {} from {}", route, (Object)routerId);
        return offset;
    }

    @Override
    public Optional<StaleBestPathRoute<C, S, R, I>> removeStalePaths(RIBSupport<C, S, R, I> ribSupport, String routeKey) {
        if (this.removedBestPath == null) {
            return Optional.empty();
        }
        this.removedBestPath = null;
        return Optional.of(new Stale(ribSupport.createRouteListKey(routeKey)));
    }

    @Override
    public List<AdvertizedRoute<C, S, R, I>> newBestPaths(RIBSupport<C, S, R, I> ribSupport, String routeKey) {
        if (this.bestPath == null) {
            return Collections.emptyList();
        }
        R route = this.createRoute(ribSupport, routeKey);
        AdvertizedRoute adv = new AdvertizedRoute(ribSupport, route, this.bestPath.getAttributes(), this.bestPath.getPeerId(), this.bestPath.isDepreferenced());
        LOG.trace("Selected best route {}", route);
        return Collections.singletonList(adv);
    }

    @Override
    public List<ActualBestPathRoutes<C, S, R, I>> actualBestPaths(RIBSupport<C, S, R, I> ribSupport, RouteEntryInfo entryInfo) {
        if (this.bestPath == null) {
            return Collections.emptyList();
        }
        R route = this.createRoute(ribSupport, entryInfo.getRouteKey());
        return Collections.singletonList(new ActualBestPathRoutes(ribSupport, route, this.bestPath.getPeerId(), this.bestPath.getAttributes(), this.bestPath.isDepreferenced()));
    }

    private static final class Stale<C extends Routes & DataObject, S extends ChildOf<? super C>, R extends Route & ChildOf<? super S>, I extends Identifier<R>>
    extends StaleBestPathRoute<C, S, R, I> {
        Stale(I nonAddPathRouteKeyIdentifier) {
            super(nonAddPathRouteKeyIdentifier);
        }

        public List<I> getStaleRouteKeyIdentifiers() {
            return Collections.singletonList(this.getNonAddPathRouteKeyIdentifier());
        }

        public List<I> getAddPathRouteKeyIdentifiers() {
            return Collections.emptyList();
        }

        public boolean isNonAddPathBestPathNew() {
            return true;
        }
    }
}

